/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.tagcloud;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.tagcloud.model.Type;
import ch.hsr.ifs.cdt.metriculator.tagcloud.views.TagCloudViewPart;
import ch.hsr.ifs.cdt.metriculator.views.ITagCloudDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class GenerateTagCloudAction
implements IViewActionDelegate {
    private ITagCloudDataProvider view;

    public void run(IAction action) {
        if (this.view != null) {
            AbstractMetric metric = this.view.getMenuMetric();
            Collection nodes = this.view.getNodes();
            this.generateTagCloud(nodes, metric);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        if (view instanceof ITagCloudDataProvider) {
            this.view = (ITagCloudDataProvider)view;
        }
    }

    public void generateTagCloud(Collection<AbstractNode> nodes, AbstractMetric metric) {
        ProgressMonitorDialog dialog = null;
        try {
            try {
                dialog = new ProgressMonitorDialog(null);
                dialog.setBlockOnOpen(false);
                dialog.open();
                IProgressMonitor pm = dialog.getProgressMonitor();
                pm.beginTask("Generating tag cloud ...", -1);
                ArrayList<Type> types = new ArrayList<Type>();
                for (AbstractNode n : nodes) {
                    String nodeName = n.toString();
                    if (nodeName.length() > 20) {
                        nodeName = nodeName.substring(0, 20);
                    }
                    types.add(new Type(nodeName, n.getNodeValue(metric.getKey())));
                }
                IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.hsr.ifs.cdt.metriculator.tagcloud.TagCloudView");
                ((TagCloudViewPart)view).getViewer().setInput(types, pm);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (dialog != null) {
                    dialog.close();
                }
            }
        }
        finally {
            if (dialog != null) {
                dialog.close();
            }
        }
    }
}

