/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.tagcloud.views;

import ch.hsr.ifs.cdt.metriculator.tagcloud.model.Type;
import ch.hsr.ifs.cdt.metriculator.tagcloud.views.TypeLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.cloudio.CloudOptionsComposite;
import org.eclipse.zest.cloudio.TagCloud;
import org.eclipse.zest.cloudio.TagCloudViewer;
import org.eclipse.zest.cloudio.layout.DefaultLayouter;
import org.eclipse.zest.cloudio.layout.ILayouter;

public class TagCloudViewPart
extends ViewPart {
    public static final String VIEW_ID = "ch.hsr.ifs.cdt.metriculator.tagcloud.TagCloudView";
    private TagCloudViewer viewer;
    private TypeLabelProvider labelProvider;
    private CloudOptionsComposite options;
    private ILayouter layouter;

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite cloudComp = new Composite((Composite)sash, 0);
        cloudComp.setLayout((Layout)new GridLayout());
        cloudComp.setLayoutData((Object)new GridData(4, 4, true, true));
        TagCloud cloud = new TagCloud(cloudComp, 768);
        cloud.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TagCloudViewer(cloud);
        this.layouter = new DefaultLayouter(20, 10);
        this.viewer.setLayouter(this.layouter);
        this.labelProvider = new TypeLabelProvider();
        this.labelProvider.setScale(TypeLabelProvider.Scaling.LINEAR);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
                List list = (List)newInput;
                if (list == null || list.size() == 0) {
                    return;
                }
                int max = Integer.MIN_VALUE;
                int min = Integer.MAX_VALUE;
                for (Object o : list) {
                    int occurrences = ((Type)o).getOccurrences();
                    if (occurrences > max) {
                        max = occurrences;
                        continue;
                    }
                    if (occurrences >= min) continue;
                    min = occurrences;
                }
                TagCloudViewPart.this.labelProvider.setMaxOccurrences(max);
                TagCloudViewPart.this.labelProvider.setMinOccurrences(min);
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Object[] types = ((List)inputElement).toArray(new Type[0]);
                Arrays.sort(types, new Comparator<Type>(){

                    @Override
                    public int compare(Type o1, Type o2) {
                        return o2.getOccurrences() - o1.getOccurrences();
                    }
                });
                return types;
            }
        });
        this.createSideTab(sash);
        cloud.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getCloud().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TagCloudViewPart.this.viewer.getCloud().zoomFit();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(new Type("Use context menu on column headers in the metriculator view.", 1));
        this.viewer.getCloud().setMaxFontSize(100);
        this.viewer.getCloud().setMinFontSize(15);
        this.labelProvider.setColors(this.options.getColors());
        this.labelProvider.setFonts(this.options.getFonts());
        sash.setWeights(new int[]{72, 28});
        this.viewer.setInput(types, (IProgressMonitor)new NullProgressMonitor());
    }

    private void createSideTab(SashForm form) {
        Composite parent = new Composite((Composite)form, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.options = new CloudOptionsComposite(parent, 0, this.viewer){

            protected Group addLayoutButtons(Composite parent) {
                Group buttons = super.addLayoutButtons(parent);
                Label l = new Label((Composite)buttons, 0);
                l.setText("Scale");
                final Combo scale = new Combo((Composite)buttons, 12);
                scale.setLayoutData((Object)new GridData(4, 128, true, false));
                scale.setItems(new String[]{"linear", "logarithmic"});
                scale.select(1);
                scale.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        switch (scale.getSelectionIndex()) {
                            case 0: {
                                TagCloudViewPart.this.labelProvider.setScale(TypeLabelProvider.Scaling.LINEAR);
                                break;
                            }
                            case 1: {
                                TagCloudViewPart.this.labelProvider.setScale(TypeLabelProvider.Scaling.LOGARITHMIC);
                                break;
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                l = new Label((Composite)buttons, 0);
                l.setText("X Axis Variation");
                final Combo xAxis = new Combo((Composite)buttons, 12);
                xAxis.setLayoutData((Object)new GridData(4, 128, true, false));
                xAxis.setItems(new String[]{"0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100"});
                xAxis.select(2);
                xAxis.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String item = xAxis.getItem(xAxis.getSelectionIndex());
                        TagCloudViewPart.this.layouter.setOption("xaxis", (Object)Integer.parseInt(item));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                l = new Label((Composite)buttons, 0);
                l.setText("Y Axis Variation");
                final Combo yAxis = new Combo((Composite)buttons, 12);
                yAxis.setLayoutData((Object)new GridData(4, 128, true, false));
                yAxis.setItems(new String[]{"0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100"});
                yAxis.select(1);
                yAxis.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String item = yAxis.getItem(yAxis.getSelectionIndex());
                        TagCloudViewPart.this.layouter.setOption("yaxis", (Object)Integer.parseInt(item));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button run = new Button((Composite)buttons, 0);
                run.setLayoutData((Object)new GridData(4, 4, true, true));
                run.setText("Re-Position");
                run.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(viewer.getControl().getShell());
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                        dialog.getProgressMonitor().beginTask("Layouting tag cloud...", 100);
                        viewer.reset(dialog.getProgressMonitor(), false);
                        dialog.close();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button layout = new Button((Composite)buttons, 0);
                layout.setLayoutData((Object)new GridData(4, 4, true, true));
                layout.setText("Re-Layout");
                layout.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(viewer.getControl().getShell());
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                        dialog.getProgressMonitor().beginTask("Layouting tag cloud...", 200);
                        viewer.setInput(viewer.getInput(), dialog.getProgressMonitor());
                        viewer.reset(dialog.getProgressMonitor(), false);
                        dialog.close();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return buttons;
            }
        };
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.options.setLayoutData((Object)gd);
    }

    public void setFocus() {
        this.viewer.getCloud().setFocus();
    }

    public void dispose() {
        this.viewer.getCloud().dispose();
        this.labelProvider.dispose();
    }

    public TagCloudViewer getViewer() {
        return this.viewer;
    }
}

