/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.tagcloud.views;

import ch.hsr.ifs.cdt.metriculator.tagcloud.model.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.cloudio.IEditableCloudLabelProvider;

public class TypeLabelProvider
extends BaseLabelProvider
implements IEditableCloudLabelProvider {
    private double maxOccurrences;
    private double minOccurrences;
    private Map<Object, Color> colors = new HashMap<Object, Color>();
    private Map<Object, FontData[]> fonts = new HashMap<Object, FontData[]>();
    private Random random = new Random();
    protected List<Color> colorList;
    protected List<Font> fontList;
    protected List<Float> angles;
    private Scaling scaling = Scaling.LOGARITHMIC;

    public TypeLabelProvider() {
        this.colorList = new ArrayList<Color>();
        this.fontList = new ArrayList<Font>();
        this.angles = new ArrayList<Float>();
        this.angles.add(Float.valueOf(0.0f));
    }

    public String getLabel(Object element) {
        return ((Type)element).getString();
    }

    public double getWeight(Object element) {
        switch (this.scaling) {
            case LINEAR: {
                return (double)((Type)element).getOccurrences() / this.maxOccurrences;
            }
            case LOGARITHMIC: {
                double count = Math.log((double)((Type)element).getOccurrences() - this.minOccurrences + 1.0);
                return count /= Math.log(this.maxOccurrences);
            }
        }
        return 1.0;
    }

    public Color getColor(Object element) {
        Color color = this.colors.get(element);
        if (color == null) {
            color = this.colorList.get(this.random.nextInt(this.colorList.size()));
            this.colors.put(element, color);
        }
        return color;
    }

    public FontData[] getFontData(Object element) {
        FontData[] data = this.fonts.get(element);
        if (data == null) {
            data = this.fontList.get(this.random.nextInt(this.fontList.size())).getFontData();
            this.fonts.put(element, data);
        }
        return data;
    }

    public void setMaxOccurrences(int occurrences) {
        this.maxOccurrences = occurrences;
    }

    public void setMinOccurrences(int occurrences) {
        this.minOccurrences = occurrences;
    }

    public void dispose() {
        for (Color color : this.colorList) {
            color.dispose();
        }
        for (Font font : this.fontList) {
            font.dispose();
        }
    }

    public void setAngles(List<Float> angles) {
        this.angles = angles;
    }

    public float getAngle(Object element) {
        float angle = this.angles.get(this.random.nextInt(this.angles.size())).floatValue();
        return angle;
    }

    public void setColors(List<RGB> newColors) {
        if (newColors.isEmpty()) {
            return;
        }
        for (Color color : this.colorList) {
            color.dispose();
        }
        this.colorList.clear();
        this.colors.clear();
        for (RGB rGB : newColors) {
            Color c = new Color((Device)Display.getDefault(), rGB);
            this.colorList.add(c);
        }
    }

    public void setFonts(List<FontData> newFonts) {
        if (newFonts.isEmpty()) {
            return;
        }
        for (Font font : this.fontList) {
            font.dispose();
        }
        this.fontList.clear();
        this.fonts.clear();
        for (FontData data : newFonts) {
            Font f = new Font((Device)Display.getDefault(), data);
            this.fontList.add(f);
        }
    }

    public String getToolTip(Object element) {
        return this.getLabel(element);
    }

    public void setScale(Scaling scaling) {
        this.scaling = scaling;
    }

    public static enum Scaling {
        LINEAR,
        LOGARITHMIC;

    }
}

