/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator;

import ch.hsr.ifs.cdt.metriculator.JobObservable;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.FlatTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.HybridTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.LogicTreeBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Observable;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MetriculatorPluginActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "ch.hsr.ifs.cdt.metriculator";
    private static MetriculatorPluginActivator plugin;
    private JobObservable observable = new JobObservable();
    HashMap<Class<AbstractMetric>, AbstractMetric> metrics = new HashMap();
    private HybridTreeBuilder hybridTreeBuilder;
    private FlatTreeBuilder flatTreeBuilder;
    private LogicTreeBuilder logicTreeBuilder;

    public Observable getObservable() {
        return this.observable;
    }

    public MetriculatorPluginActivator() {
        this.resetTreeBuilders();
        this.addCommandExecutionListener();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static MetriculatorPluginActivator getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return MetriculatorPluginActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void resetTreeBuilders() {
        this.hybridTreeBuilder = new HybridTreeBuilder("Workspace");
        this.flatTreeBuilder = null;
        this.logicTreeBuilder = null;
    }

    public HybridTreeBuilder getHybridTreeBuilder() {
        return this.hybridTreeBuilder;
    }

    public FlatTreeBuilder getFlatTreeBuilder() {
        if (this.flatTreeBuilder == null) {
            this.flatTreeBuilder = FlatTreeBuilder.buildFrom(this.hybridTreeBuilder);
        }
        return this.flatTreeBuilder;
    }

    public LogicTreeBuilder getLogicTreeBuilder() {
        if (this.logicTreeBuilder == null) {
            this.logicTreeBuilder = LogicTreeBuilder.buildFrom(this.hybridTreeBuilder);
        }
        return this.logicTreeBuilder;
    }

    private void showMetriculatorView() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.showView("ch.hsr.ifs.cdt.metriculator.views.MetriculatorView");
                    page.addPartListener(new IPartListener2(){

                        public void partClosed(IWorkbenchPartReference partRef) {
                            if (partRef.getId().equals("ch.hsr.ifs.cdt.metriculator.views.MetriculatorView")) {
                                MetriculatorPluginActivator.this.resetTreeBuilders();
                                MetriculatorPluginActivator.this.resetMetricCaches();
                                System.gc();
                            }
                        }

                        public void partVisible(IWorkbenchPartReference partRef) {
                        }

                        public void partOpened(IWorkbenchPartReference partRef) {
                        }

                        public void partInputChanged(IWorkbenchPartReference partRef) {
                        }

                        public void partHidden(IWorkbenchPartReference partRef) {
                        }

                        public void partDeactivated(IWorkbenchPartReference partRef) {
                        }

                        public void partBroughtToTop(IWorkbenchPartReference partRef) {
                        }

                        public void partActivated(IWorkbenchPartReference partRef) {
                        }
                    });
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void addCommandExecutionListener() {
        Job.getJobManager().addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (event.getJob().getName().equals(CodanUIMessages.Job_TitleRunningAnalysis)) {
                    MetriculatorPluginActivator.this.aggregateMetricValues();
                    if (MetriculatorPluginActivator.this.isAnyMetricProblemEnabled()) {
                        MetriculatorPluginActivator.this.showMetriculatorView();
                    }
                    MetriculatorPluginActivator.this.observable.setChangedAndNotifyJobDone();
                }
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
                if (event.getJob().getName().equals(CodanUIMessages.Job_TitleRunningAnalysis)) {
                    MetriculatorPluginActivator.this.resetTreeBuilders();
                    MetriculatorPluginActivator.this.resetMetricCaches();
                    System.gc();
                    MetriculatorPluginActivator.this.observable.setChangedAndNotifyJobAboutToRun();
                }
            }
        });
    }

    private void aggregateMetricValues() {
        for (AbstractMetric m : this.getMetrics()) {
            this.hybridTreeBuilder.root.getValueOf(m);
            m.useCachedValue = true;
        }
    }

    private void resetMetricCaches() {
        for (AbstractMetric m : this.getMetrics()) {
            m.useCachedValue = false;
        }
    }

    private boolean isAnyMetricProblemEnabled() {
        for (AbstractMetric m : this.getMetrics()) {
            if (!m.getChecker().hasEnabledProblems()) continue;
            return true;
        }
        return false;
    }

    public void registerMetric(AbstractMetric metric) {
        if (!this.metrics.containsKey(metric.getClass())) {
            this.metrics.put(metric.getClass(), metric);
        }
    }

    public Collection<AbstractMetric> getMetrics() {
        return Collections.unmodifiableCollection(this.metrics.values());
    }
}

