/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.checkers.LSLOCMetric;
import ch.hsr.ifs.cdt.metriculator.checkers.LSLOCScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetricChecker;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FileNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionNode;
import ch.hsr.ifs.cdt.metriculator.resources.MetricLabels;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class LSLOCMetricChecker
extends AbstractMetricChecker {
    public static final String PREF_LSLOC_MAXIMUM_PER_FILE = "max_per_file";
    public static final String PREF_LSLOC_MAXIMUM_PER_FUNCTION = "max_per_function";
    public static final String LSLOC_PROBLEM_ID = "ch.hsr.ifs.cdt.metriculator.lsloc";
    private final String key = AbstractMetric.getKeyFor(LSLOCMetric.class);
    private LSLOCMetric metric = new LSLOCMetric(this, MetricLabels.LSLOCMetric_name, MetricLabels.LSLOCMetric_description);

    public LSLOCMetricChecker() {
        super(LSLOC_PROBLEM_ID);
        MetriculatorPluginActivator.getDefault().registerMetric(this.metric);
    }

    @Override
    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PREF_LSLOC_MAXIMUM_PER_FILE, MetricLabels.LSLOC_Maximum_Per_File, "100");
        this.addPreference(problem, PREF_LSLOC_MAXIMUM_PER_FUNCTION, MetricLabels.LSLOC_Maximum_Per_Function, "20");
    }

    @Override
    protected void processTanslationUnit(IASTTranslationUnit tu) {
        LSLOCScopedASTVisitor visitor = new LSLOCScopedASTVisitor(this.currentScopeNode, this.builder);
        visitor.add(this);
        tu.accept((ASTVisitor)visitor);
        if (tu.getAllPreprocessorStatements().length > 0) {
            this.currentScopeNode.setNodeValue(this.key, this.currentScopeNode.getNodeValue(this.key) + tu.getAllPreprocessorStatements().length);
        }
        this.reportProblemsFor((FileNode)this.currentScopeNode);
    }

    @Override
    protected void reportProblemsFor(AbstractNode node) {
        Integer maxLSLOCPerFile;
        if (node instanceof FunctionNode) {
            Integer maxLSLOCPerFunction = this.getPreferenceAsInteger(LSLOC_PROBLEM_ID, PREF_LSLOC_MAXIMUM_PER_FUNCTION, this.getFile());
            if (node.getValueOf((AbstractMetric)this.metric).aggregatedValue > maxLSLOCPerFunction) {
                this.reportProblem(LSLOC_PROBLEM_ID, node, maxLSLOCPerFunction);
            }
        } else if (node instanceof FileNode && node.getValueOf((AbstractMetric)this.metric).aggregatedValue > (maxLSLOCPerFile = this.getPreferenceAsInteger(LSLOC_PROBLEM_ID, PREF_LSLOC_MAXIMUM_PER_FILE, this.getFile()))) {
            this.reportProblem(LSLOC_PROBLEM_ID, node, maxLSLOCPerFile);
        }
    }
}

