/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.checkers.LSLOCMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.ScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;

public class LSLOCScopedASTVisitor
extends ScopedASTVisitor {
    private List<IASTNode> astNodesToIgnore = new ArrayList<IASTNode>();
    private String key = AbstractMetric.getKeyFor(LSLOCMetric.class);

    public LSLOCScopedASTVisitor(AbstractNode scopeNode, AbstractTreeBuilder builder) {
        super(scopeNode, builder);
    }

    private void count(IASTNode node) {
        if (!this.astNodesToIgnore.contains(node)) {
            this.scopeNode.setNodeValue(this.key, this.scopeNode.getNodeValue(this.key) + 1);
        }
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        super.visit(namespaceDefinition);
        this.count((IASTNode)namespaceDefinition);
        return 3;
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        super.visit(declaration);
        if (declaration instanceof IASTSimpleDeclaration) {
            if (declaration.getChildren().length > 0 && declaration.getChildren()[0] instanceof ICPPASTCompositeTypeSpecifier) {
                this.astNodesToIgnore.add((IASTNode)declaration);
            } else {
                this.count((IASTNode)declaration);
            }
        } else if (declaration instanceof ICPPASTUsingDirective) {
            this.count((IASTNode)declaration);
        }
        return 3;
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        int process_status = super.visit(declSpec);
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            IASTNode[] children = declSpec.getParent().getChildren();
            if (children.length > 1 && children[1] instanceof ICPPASTDeclarator) {
                this.count(children[1]);
            }
            this.count((IASTNode)declSpec);
        }
        return process_status;
    }

    public int visit(IASTStatement statement) {
        if (this.shouldAnalyseChildrenOf(statement)) {
            int currChildNumber = 0;
            int nrOfChildren = statement.getChildren().length;
            IASTNode[] iASTNodeArray = statement.getChildren();
            int n = iASTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isNotLastChildAndNotCatch;
                IASTNode child = iASTNodeArray[n2];
                ++currChildNumber;
                if (!(child instanceof IASTStatement)) {
                    this.astNodesToIgnore.add(child);
                }
                boolean isLastChild = currChildNumber == nrOfChildren;
                boolean isElseChild = !isLastChild && statement instanceof ICPPASTIfStatement && child instanceof IASTCompoundStatement;
                boolean bl = isNotLastChildAndNotCatch = !isLastChild && !(child instanceof ICPPASTCatchHandler);
                if (isElseChild || isNotLastChildAndNotCatch || child instanceof IASTCompoundStatement || child instanceof IASTNullStatement) {
                    this.astNodesToIgnore.add(child);
                }
                if (this.isDeclarationWithSimpleDeclaration(child)) {
                    this.astNodesToIgnore.add(child.getChildren()[0]);
                }
                ++n2;
            }
        }
        if (this.isDeclarationWithSimpleDeclaration((IASTNode)statement) || this.isDeclarationWithUsingDirective(statement)) {
            this.astNodesToIgnore.add((IASTNode)statement);
        }
        if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
            this.astNodesToIgnore.add((IASTNode)statement);
        }
        this.count((IASTNode)statement);
        return 3;
    }

    private boolean shouldAnalyseChildrenOf(IASTStatement statement) {
        return this.isIterationStatement(statement) || statement instanceof ICPPASTIfStatement || statement instanceof IASTSwitchStatement || statement instanceof ICPPASTTryBlockStatement || statement instanceof ICPPASTCatchHandler;
    }

    private boolean isIterationStatement(IASTStatement statement) {
        return statement instanceof IASTDoStatement || statement instanceof ICPPASTForStatement || statement instanceof ICPPASTWhileStatement;
    }

    private boolean isDeclarationWithSimpleDeclaration(IASTNode statement) {
        return statement instanceof IASTDeclarationStatement && statement.getChildren().length > 0 && statement.getChildren()[0] instanceof IASTSimpleDeclaration;
    }

    private boolean isDeclarationWithUsingDirective(IASTStatement statement) {
        return statement instanceof IASTDeclarationStatement && statement.getChildren().length > 0 && statement.getChildren()[0] instanceof ICPPASTUsingDirective;
    }
}

