/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.checkers.McCabeMetric;
import ch.hsr.ifs.cdt.metriculator.checkers.McCabeScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetricChecker;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionNode;
import ch.hsr.ifs.cdt.metriculator.resources.MetricLabels;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class McCabeMetricChecker
extends AbstractMetricChecker {
    public static final String PREF_MCCABE_MAXIMUM_PER_FUNCTION = "max_per_function";
    public static final String MCCABE_PROBLEM_ID = "ch.hsr.ifs.cdt.metriculator.mccabe";
    private McCabeMetric metric = new McCabeMetric(this, MetricLabels.McCabeMetric_name, MetricLabels.McCabeMetric_description);

    public McCabeMetricChecker() {
        super(MCCABE_PROBLEM_ID);
        MetriculatorPluginActivator.getDefault().registerMetric(this.metric);
    }

    @Override
    protected void processTanslationUnit(IASTTranslationUnit tu) {
        McCabeScopedASTVisitor visitor = new McCabeScopedASTVisitor(this.currentScopeNode, this.builder);
        visitor.add(this);
        tu.accept((ASTVisitor)visitor);
    }

    @Override
    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PREF_MCCABE_MAXIMUM_PER_FUNCTION, MetricLabels.MCCABE_Maximum_Per_Function, "15");
    }

    @Override
    protected void reportProblemsFor(AbstractNode node) {
        Integer maxMcCabePerFunction;
        if (node instanceof FunctionNode && node.getValueOf((AbstractMetric)this.metric).aggregatedValue > (maxMcCabePerFunction = this.getPreferenceAsInteger(MCCABE_PROBLEM_ID, PREF_MCCABE_MAXIMUM_PER_FUNCTION, this.getFile()))) {
            this.reportProblem(MCCABE_PROBLEM_ID, node, maxMcCabePerFunction);
        }
    }
}

