/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.checkers.McCabeMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.ScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;

public class McCabeScopedASTVisitor
extends ScopedASTVisitor {
    String key = AbstractMetric.getKeyFor(McCabeMetric.class);

    public McCabeScopedASTVisitor(AbstractNode scopeNode, AbstractTreeBuilder builder) {
        super(scopeNode, builder);
        this.shouldVisitExpressions = true;
        this.shouldVisitTranslationUnit = true;
    }

    public int visit(IASTStatement statement) {
        if (this.isComplexity(statement)) {
            this.count();
        }
        return 3;
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof ICPPASTBinaryExpression && this.isComplexityLogic((ICPPASTBinaryExpression)expression)) {
            if (this.isNotOverloaded((ICPPASTBinaryExpression)expression)) {
                this.count();
            }
        } else if (expression instanceof IASTConditionalExpression) {
            this.count();
        }
        return 3;
    }

    public int visit(IASTTranslationUnit tu) {
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = tu.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (this.isComplexityPreProcessor(statement)) {
                this.count();
            }
            ++n2;
        }
        return 3;
    }

    private boolean isNotOverloaded(ICPPASTBinaryExpression expression) {
        return expression.getOverload() == null;
    }

    private void count() {
        this.scopeNode.setNodeValue(this.key, this.scopeNode.getNodeValue(this.key) + 1);
    }

    private boolean isComplexity(IASTStatement statement) {
        return statement instanceof ICPPASTIfStatement || statement instanceof ICPPASTForStatement || statement instanceof ICPPASTWhileStatement || statement instanceof IASTCaseStatement || statement instanceof ICPPASTCatchHandler;
    }

    private boolean isComplexityPreProcessor(IASTPreprocessorStatement statement) {
        return statement instanceof IASTPreprocessorIfStatement || statement instanceof IASTPreprocessorIfdefStatement || statement instanceof IASTPreprocessorIfndefStatement || statement instanceof IASTPreprocessorElifStatement;
    }

    private boolean isComplexityLogic(ICPPASTBinaryExpression expression) {
        return expression.getOperator() == 15 || expression.getOperator() == 16;
    }
}

