/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.checkers.NumberMembersMetric;
import ch.hsr.ifs.cdt.metriculator.checkers.NumberMembersScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetricChecker;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDefNode;
import ch.hsr.ifs.cdt.metriculator.resources.MetricLabels;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class NumberMembersMetricChecker
extends AbstractMetricChecker {
    public static final String PREF_NBMEMBERS_MAXIMUM_PER_TYPE = "max_per_function";
    public static final String NBMEMBERS_PROBLEM_ID = "ch.hsr.ifs.cdt.metriculator.classmembers";
    private NumberMembersMetric metric = new NumberMembersMetric(this, MetricLabels.NumberMembersMetric_name, MetricLabels.NumberMembersMetric_description);

    public NumberMembersMetricChecker() {
        super(NBMEMBERS_PROBLEM_ID);
        MetriculatorPluginActivator.getDefault().registerMetric(this.metric);
    }

    @Override
    protected void processTanslationUnit(IASTTranslationUnit tu) {
        NumberMembersScopedASTVisitor visitor = new NumberMembersScopedASTVisitor(this.currentScopeNode, this.builder);
        visitor.add(this);
        tu.accept((ASTVisitor)visitor);
    }

    @Override
    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PREF_NBMEMBERS_MAXIMUM_PER_TYPE, MetricLabels.NBMEMBERS_Maximum_Per_Type, "20");
    }

    @Override
    protected void reportProblemsFor(AbstractNode node) {
        Integer maxNbMembersPerType;
        if (node instanceof TypeDefNode && node.getValueOf((AbstractMetric)this.metric).aggregatedValue > (maxNbMembersPerType = this.getPreferenceAsInteger(NBMEMBERS_PROBLEM_ID, PREF_NBMEMBERS_MAXIMUM_PER_TYPE, this.getFile()))) {
            this.reportProblem(NBMEMBERS_PROBLEM_ID, node, maxNbMembersPerType);
        }
    }
}

