/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.checkers.NumberMembersMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.ScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;

public class NumberMembersScopedASTVisitor
extends ScopedASTVisitor {
    String key = AbstractMetric.getKeyFor(NumberMembersMetric.class);

    public NumberMembersScopedASTVisitor(AbstractNode scopeNode, AbstractTreeBuilder builder) {
        super(scopeNode, builder);
        this.shouldVisitDeclarators = true;
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        int process_status = super.visit(declSpec);
        if (declSpec instanceof IASTCompositeTypeSpecifier) {
            IASTDeclaration[] members;
            IASTDeclaration[] iASTDeclarationArray = members = ((IASTCompositeTypeSpecifier)declSpec).getMembers();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration member = iASTDeclarationArray[n2];
                if (!(member instanceof ICPPASTVisibilityLabel) && !(member instanceof ICPPASTUsingDeclaration) && this.isNotFriend(member)) {
                    this.count();
                }
                ++n2;
            }
        }
        return process_status;
    }

    private boolean isNotFriend(IASTDeclaration member) {
        if (member instanceof ICPPASTFunctionDefinition) {
            return !((ICPPASTFunctionDefinition)member).getDeclSpecifier().getRawSignature().contains("friend");
        }
        if (member instanceof IASTSimpleDeclaration) {
            return !((IASTSimpleDeclaration)member).getDeclSpecifier().getRawSignature().contains("friend");
        }
        return true;
    }

    private void count() {
        this.scopeNode.setNodeValue(this.key, this.scopeNode.getNodeValue(this.key) + 1);
    }
}

