/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.checkers;

import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.checkers.NumberParamsMetric;
import ch.hsr.ifs.cdt.metriculator.checkers.NumberParamsScopedASTVisitor;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetricChecker;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionNode;
import ch.hsr.ifs.cdt.metriculator.resources.MetricLabels;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class NumberParamsMetricChecker
extends AbstractMetricChecker {
    public static final String PREF_NBPARAMS_MAXIMUM_PER_FUNCTION = "max_per_function";
    public static final String NBPARAMS_PROBLEM_ID = "ch.hsr.ifs.cdt.metriculator.nbparams";
    private NumberParamsMetric metric = new NumberParamsMetric(this, MetricLabels.NumberParamsMetric_name, MetricLabels.NumberParamsMetric_description);

    public NumberParamsMetricChecker() {
        super(NBPARAMS_PROBLEM_ID);
        MetriculatorPluginActivator.getDefault().registerMetric(this.metric);
    }

    @Override
    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PREF_NBPARAMS_MAXIMUM_PER_FUNCTION, MetricLabels.NBPARAMS_Maximum_Per_Function, "4");
    }

    @Override
    protected void processTanslationUnit(IASTTranslationUnit tu) {
        NumberParamsScopedASTVisitor visitor = new NumberParamsScopedASTVisitor(this.currentScopeNode, this.builder);
        visitor.add(this);
        tu.accept((ASTVisitor)visitor);
    }

    @Override
    protected void reportProblemsFor(AbstractNode node) {
        Integer maxNbParamsPerFunction;
        if (node instanceof FunctionNode && node.getValueOf((AbstractMetric)this.metric).aggregatedValue > (maxNbParamsPerFunction = this.getPreferenceAsInteger(NBPARAMS_PROBLEM_ID, PREF_NBPARAMS_MAXIMUM_PER_FUNCTION, this.getFile()))) {
            this.reportProblem(NBPARAMS_PROBLEM_ID, node, maxNbParamsPerFunction);
        }
    }
}

