/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetricChecker;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.CompositeValue;

public abstract class AbstractMetric {
    protected AbstractMetricChecker checker;
    private String name;
    private String description;
    public boolean useCachedValue = false;

    protected AbstractMetric(AbstractMetricChecker checker, String name, String description) {
        this.checker = checker;
        this.name = name;
        this.description = description;
    }

    public String getKey() {
        return this.getClass().getName();
    }

    public int aggregate(AbstractNode node) {
        CompositeValue metricValue = node.getValueOrDefaultOf(this.getKey());
        metricValue.aggregatedValue = 0;
        for (AbstractNode child : node.getChildren()) {
            metricValue.aggregatedValue += this.aggregate(child);
        }
        metricValue.aggregatedValue += metricValue.nodeValue;
        return metricValue.aggregatedValue;
    }

    public AbstractMetricChecker getChecker() {
        return this.checker;
    }

    public static String getKeyFor(Class<? extends AbstractMetric> metric) {
        return metric.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

