/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.JobObservable;
import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.HybridTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.IScopeListener;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.ProjectNode;
import ch.hsr.ifs.cdt.metriculator.resources.MetricLabels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.BasicProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class AbstractMetricChecker
extends AbstractIndexAstChecker
implements Observer,
IScopeListener {
    private static final String PREF_REPORT_CHECKER_PROBLEMS = "report_problems";
    private final String PROBLEM_ID;
    private HashMap<String, Collection<IProblem>> reportedProblems = new HashMap();
    protected AbstractNode currentScopeNode;
    protected HybridTreeBuilder builder;

    protected AbstractMetricChecker(String problemId) {
        this.PROBLEM_ID = problemId;
    }

    public synchronized boolean processResource(IResource resource) throws OperationCanceledException {
        this.builder = MetriculatorPluginActivator.getDefault().getHybridTreeBuilder();
        this.currentScopeNode = this.builder.addChild(this.builder.root, new ProjectNode(resource.getProject()));
        return super.processResource(resource);
    }

    public boolean runInEditor() {
        return false;
    }

    public void processAst(IASTTranslationUnit ast) {
        if (ast.getFilePath().lastIndexOf(".c") == ast.getFilePath().length() - 2) {
            return;
        }
        AbstractNode fileSystemLeaf = AbstractTreeBuilder.createTreeFromPath((ProjectNode)this.currentScopeNode, ast);
        AbstractNode fileSystemTop = fileSystemLeaf.getRoot();
        this.currentScopeNode = this.builder.addChild(this.currentScopeNode, fileSystemTop);
        this.currentScopeNode = this.builder.getChildBy(fileSystemLeaf.getHybridId());
        this.processTanslationUnit(ast);
        this.builder.mergeDeclarationsAndDefinitions(ast);
        this.currentScopeNode = fileSystemTop.getParent();
    }

    protected abstract void processTanslationUnit(IASTTranslationUnit var1);

    public static <T extends AbstractMetricChecker> T getChecker(Class<T> clazz) {
        for (IChecker checker : CodanRuntime.getInstance().getCheckersRegistry()) {
            if (!checker.getClass().equals(clazz)) continue;
            return (T)((AbstractMetricChecker)clazz.cast(checker));
        }
        return null;
    }

    public static Collection<AbstractMetricChecker> getMetricCheckers() {
        ArrayList<AbstractMetricChecker> checkers = new ArrayList<AbstractMetricChecker>();
        for (IChecker chk : CodanRuntime.getInstance().getCheckersRegistry()) {
            if (!(chk instanceof AbstractMetricChecker)) continue;
            checkers.add((AbstractMetricChecker)chk);
        }
        return Collections.unmodifiableCollection(checkers);
    }

    public Collection<IProblem> getProblemsFor(AbstractNode node) {
        return this.reportedProblems.get(node.getHybridId());
    }

    public boolean hasEnabledProblems() {
        ICheckersRegistry checkersRegistry = CodanRuntime.getInstance().getCheckersRegistry();
        IProblem[] profileProblems = checkersRegistry.getWorkspaceProfile().getProblems();
        for (IProblem p : checkersRegistry.getRefProblems((IChecker)this)) {
            IProblem[] iProblemArray = profileProblems;
            int n = profileProblems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem profileProblem = iProblemArray[n2];
                if (profileProblem.getId().equalsIgnoreCase(p.getId()) && profileProblem.isEnabled()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void reportProblem(String problemId, AbstractNode abstractNode, Object ... messageParameters) {
        IProblemLocation loc;
        if (this.reportedProblems.get(abstractNode.getHybridId()) == null) {
            this.reportedProblems.put(abstractNode.getHybridId(), new ArrayList());
        }
        this.reportedProblems.get(abstractNode.getHybridId()).add(this.getProblemById(problemId, (IResource)this.getFile()));
        this.reportedProblems.put(abstractNode.getHybridId(), this.reportedProblems.get(abstractNode.getHybridId()));
        if (this.getShouldReportProblems() && (loc = abstractNode.getEditorInfo().createAndGetProblemLocation(this.getFile())) != null) {
            super.reportProblem(problemId, loc, messageParameters);
        }
    }

    public Integer getPreferenceAsInteger(String problemId, String prefKey, IFile file) {
        Object prefValue = this.getPreference(this.getProblemById(problemId, (IResource)file), prefKey);
        return Integer.valueOf(prefValue.toString());
    }

    public boolean getShouldReportProblems() {
        Object prefValue = this.getPreference(this.getProblemById(this.PROBLEM_ID, (IResource)this.getFile()), PREF_REPORT_CHECKER_PROBLEMS);
        return Boolean.valueOf(prefValue.toString());
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, (IProblemPreference)new BasicProblemPreference(PREF_REPORT_CHECKER_PROBLEMS, MetricLabels.REPORT_CHECKER_PROBLEMS, IProblemPreferenceDescriptor.PreferenceType.TYPE_BOOLEAN), false);
        MetriculatorPluginActivator.getDefault().getObservable().addObserver(this);
    }

    @Override
    public void update(Observable observable, Object state) {
        if (state instanceof JobObservable.JobState && (JobObservable.JobState)((Object)state) == JobObservable.JobState.JOB_ABOUT_TO_RUN) {
            this.reportedProblems.clear();
            this.currentScopeNode = null;
            this.builder = null;
        }
    }

    @Override
    public void leaving(AbstractNode node) {
        this.reportProblemsFor(node);
    }

    @Override
    public void visiting(AbstractNode scopeNode) {
    }

    protected abstract void reportProblemsFor(AbstractNode var1);
}

