/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FileNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FolderNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.ProjectNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractTreeBuilder {
    public AbstractNode root;
    public static final String PATH_SEPARATOR = "#";
    public static final String LOGIC_SEPARATOR = "::";

    public AbstractNode addChild(AbstractNode parent, AbstractNode child) {
        child = parent.add(child);
        return child;
    }

    public static AbstractNode createTreeFromPath(ProjectNode projectNode, IASTTranslationUnit tu) {
        IPath projRel = PathUtil.getProjectRelativePath((IPath)new Path(tu.getFilePath()), (IProject)projectNode.getProject()).setDevice(null);
        return AbstractTreeBuilder.createTreeFromPath(projectNode.getHybridId(), projRel, tu);
    }

    public static AbstractNode createTreeFromPath(IPath projectRelativePath, IASTTranslationUnit tu) {
        return AbstractTreeBuilder.createTreeFromPath("", projectRelativePath, tu);
    }

    public static AbstractNode createTreeFromPath(String hybridIdPrefix, IPath projectRelativePath, IASTTranslationUnit tu) {
        AbstractNode currentNode = null;
        String segment = null;
        int nrOfSegments = projectRelativePath.segmentCount();
        int segmentIndex = 0;
        while (segmentIndex < nrOfSegments) {
            AbstractNode newNode;
            segment = projectRelativePath.segments()[segmentIndex];
            boolean isLastSegment = segmentIndex == nrOfSegments - 1;
            AbstractNode abstractNode = newNode = isLastSegment ? new FileNode(tu, segment) : new FolderNode(tu, segment);
            if (currentNode == null) {
                newNode.setHybridId(AbstractTreeBuilder.combine(PATH_SEPARATOR, hybridIdPrefix, newNode.getScopeUniqueName()));
                currentNode = newNode;
            } else {
                newNode.setHybridId(AbstractTreeBuilder.buildPath(hybridIdPrefix, currentNode, newNode));
                currentNode = currentNode.add(newNode);
            }
            ++segmentIndex;
        }
        return currentNode;
    }

    private static String buildPath(String prefix, AbstractNode parent, AbstractNode child) {
        if (prefix != null && prefix.length() > 0) {
            return AbstractTreeBuilder.combine(PATH_SEPARATOR, prefix, parent.getPath(), child.getScopeUniqueName());
        }
        return AbstractTreeBuilder.combine(PATH_SEPARATOR, parent.getPath(), child.getScopeUniqueName());
    }

    public static String combine(String delimeter, String ... s) {
        int k = s.length;
        if (k == 0) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append(s[0]);
        int x = 1;
        while (x < k) {
            out.append(delimeter).append(s[x]);
            ++x;
        }
        return out.toString();
    }
}

