/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.PreOrderTreeVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionDeclNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.MemberNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDeclNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.WorkspaceNode;
import java.util.HashMap;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.index.IIndexBinding;

public class HybridTreeBuilder
extends AbstractTreeBuilder {
    private HashMap<String, AbstractNode> descendants = new HashMap();
    private HashMap<IIndexBinding, MemberNode> declarations = new HashMap();

    public HybridTreeBuilder(String workspace) {
        this.root = new WorkspaceNode(workspace);
    }

    @Override
    public AbstractNode addChild(AbstractNode parent, AbstractNode child) {
        String childsHybridId = HybridTreeBuilder.combine("#", parent.getHybridId(), child.getScopeUniqueName());
        AbstractNode existing = parent.getChildBy(childsHybridId);
        this.prepareDeclBinding(child);
        if (existing != null) {
            this.mergeChildrenOf(child, existing);
            child = existing;
        } else {
            child.setHybridId(childsHybridId);
            child = parent.add(child);
            PreOrderTreeVisitor visitor = new PreOrderTreeVisitor(){

                @Override
                protected void visitNode(AbstractNode n) {
                    HybridTreeBuilder.this.descendants.put(n.getHybridId(), n);
                }
            };
            visitor.visit(child);
        }
        return child;
    }

    private void mergeChildrenOf(AbstractNode node, AbstractNode intoParent) {
        for (AbstractNode n : node.getChildren()) {
            this.addChild(intoParent, n);
        }
    }

    public AbstractNode getChildBy(String hybridId) {
        return this.descendants.get(hybridId);
    }

    private void prepareDeclBinding(AbstractNode child) {
        if (child instanceof FunctionDeclNode || child instanceof TypeDeclNode) {
            this.declarations.put(((MemberNode)child).getIndexBinding(), (MemberNode)child);
        }
    }

    public void mergeDeclarationsAndDefinitions(IASTTranslationUnit tu) {
        IASTDeclaration[] iASTDeclarationArray = tu.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof IASTSimpleDeclaration) {
                IIndexBinding declBinding = null;
                declBinding = this.isTypeDecl((IASTSimpleDeclaration)decl) ? this.getTypeBinding(tu, (IASTSimpleDeclaration)decl) : this.getFuncBinding(tu, ((IASTSimpleDeclaration)decl).getDeclarators());
                this.findDeclsOfDefs(tu, declBinding);
            }
            ++n2;
        }
        this.deleteBindings();
    }

    private void findDeclsOfDefs(IASTTranslationUnit tu, IIndexBinding declBinding) {
        if (declBinding != null) {
            IName[] iNameArray = tu.getDefinitions((IBinding)declBinding);
            int n = iNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IName name = iNameArray[n2];
                if (name instanceof IASTName && name.isDefinition()) {
                    IASTName iastName = (IASTName)name;
                    AbstractNode foundDecl = this.declarations.get(tu.getIndex().adaptBinding(iastName.getBinding()));
                    this.removeFromTree(foundDecl);
                }
                ++n2;
            }
        }
    }

    private boolean isTypeDecl(IASTSimpleDeclaration decl) {
        return decl.getDeclSpecifier() instanceof ICPPASTElaboratedTypeSpecifier;
    }

    private IIndexBinding getTypeBinding(IASTTranslationUnit tu, IASTSimpleDeclaration decl) {
        ICPPASTElaboratedTypeSpecifier typeDecl = (ICPPASTElaboratedTypeSpecifier)decl.getDeclSpecifier();
        return tu.getIndex().adaptBinding(typeDecl.getName().getBinding());
    }

    private IIndexBinding getFuncBinding(IASTTranslationUnit tu, IASTDeclarator[] declarators) {
        IIndexBinding declBinding = null;
        if (declarators.length > 0) {
            declBinding = tu.getIndex().adaptBinding(declarators[0].getName().getBinding());
        }
        return declBinding;
    }

    private void removeFromTree(AbstractNode foundDecl) {
        if (foundDecl != null) {
            foundDecl.removeFromParent();
        }
    }

    private void deleteBindings() {
        for (MemberNode node : this.declarations.values()) {
            node.clearBindings();
        }
        this.declarations.clear();
    }
}

