/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FileNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.NamespaceNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDefNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class NodeFilter {
    public abstract boolean canPassThrough(AbstractNode var1);

    public Collection<AbstractNode> takeFrom(Collection<AbstractNode> nodes) {
        ArrayList<AbstractNode> filtered = new ArrayList<AbstractNode>();
        for (AbstractNode n : nodes) {
            if (!this.canPassThrough(n)) continue;
            filtered.add(n);
        }
        return Collections.unmodifiableCollection(filtered);
    }

    public static CompositeNodeFilter composite() {
        return new CompositeNodeFilter();
    }

    public static NoneFilter none() {
        return new NoneFilter();
    }

    public static NamespaceNodeFilter namespace() {
        return new NamespaceNodeFilter();
    }

    public static FunctionNodeFilter function() {
        return new FunctionNodeFilter();
    }

    public static FileNodeFilter file() {
        return new FileNodeFilter();
    }

    public static class CompositeNodeFilter
    extends NodeFilter {
        @Override
        public boolean canPassThrough(AbstractNode node) {
            return node instanceof TypeDefNode;
        }
    }

    public static class FileNodeFilter
    extends NodeFilter {
        @Override
        public boolean canPassThrough(AbstractNode node) {
            return node instanceof FileNode;
        }
    }

    public static class FunctionNodeFilter
    extends NodeFilter {
        @Override
        public boolean canPassThrough(AbstractNode node) {
            return node instanceof FunctionNode;
        }
    }

    public static class NamespaceNodeFilter
    extends NodeFilter {
        @Override
        public boolean canPassThrough(AbstractNode node) {
            return node instanceof NamespaceNode;
        }
    }

    public static class NoneFilter
    extends NodeFilter {
        @Override
        public boolean canPassThrough(AbstractNode node) {
            return true;
        }
    }
}

