/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.PreOrderTreeVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionDeclNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionDefNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.LogicNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.MemberNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDeclNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDefNode;
import java.util.HashMap;

public class PreOrderLogicTreeVisitor
extends PreOrderTreeVisitor {
    private HashMap<String, AbstractNode> logicNodes = new HashMap();
    private HashMap<MemberNode, String> memberNodes = new HashMap();
    private AbstractNode currentNode = null;

    @Override
    protected void visitNode(AbstractNode n) {
        if (n.getParent() == null) {
            this.currentNode = this.rootNode = n.shallowClone();
        } else if (n instanceof LogicNode) {
            AbstractNode copy = n.shallowClone();
            AbstractNode existing = this.logicNodes.get(this.getLogicalUniqueNameOf(copy));
            if (existing != null) {
                this.currentNode = existing;
                this.currentNode.addNodeValuesFrom(copy);
            } else {
                this.currentNode = this.currentNode.add(copy);
                this.logicNodes.put(this.getLogicalUniqueNameOf(copy), copy);
                this.prepareMembers((LogicNode)this.currentNode);
            }
        }
    }

    @Override
    protected void leaveNode(AbstractNode n) {
        if (n instanceof LogicNode) {
            this.currentNode = this.currentNode.getParent();
        }
    }

    private String getLogicalUniqueNameOf(AbstractNode node) {
        return this.getLogicalUniqueNameOf(node, new StringBuilder());
    }

    private String getLogicalUniqueNameOf(AbstractNode node, StringBuilder logicalNamePrefix) {
        if (node instanceof LogicNode) {
            String scopeName = node.getScopeName();
            if (((LogicNode)node).isAnonymous()) {
                scopeName = node.getScopeUniqueName();
            }
            if (logicalNamePrefix.length() == 0) {
                logicalNamePrefix.append(scopeName);
            } else {
                logicalNamePrefix.insert(0, "#").insert(0, scopeName);
            }
        }
        if (node.getParent() != null) {
            return this.getLogicalUniqueNameOf(node.getParent(), logicalNamePrefix);
        }
        return logicalNamePrefix.toString();
    }

    private void prepareMembers(LogicNode node) {
        if (node instanceof MemberNode && ((MemberNode)node).isMember()) {
            this.memberNodes.put((MemberNode)node, ((MemberNode)node).getLogicalOwnerName());
        }
    }

    public void mergeMembers() {
        for (AbstractNode abstractNode : this.memberNodes.keySet()) {
            abstractNode.removeFromParent();
            String logicalOwnerName = this.memberNodes.get(abstractNode);
            if (this.logicNodes.get(logicalOwnerName) == null) continue;
            this.logicNodes.get(logicalOwnerName).add(abstractNode);
        }
    }

    public void mergeDefinitionsAndDeclarations() {
        for (MemberNode def : this.memberNodes.keySet()) {
            if (def instanceof FunctionDefNode) {
                this.replaceFuncDeclarationWith(def);
                continue;
            }
            if (!(def instanceof TypeDefNode)) continue;
            this.replaceTypeDeclarationWith(def);
        }
    }

    private void replaceFuncDeclarationWith(MemberNode def) {
        for (MemberNode decl : this.memberNodes.keySet()) {
            if (!(decl instanceof FunctionDeclNode)) continue;
            this.removeDeclaration(def, decl);
        }
    }

    private void replaceTypeDeclarationWith(MemberNode def) {
        for (MemberNode decl : this.memberNodes.keySet()) {
            if (!(decl instanceof TypeDeclNode)) continue;
            this.removeDeclaration(def, decl);
        }
    }

    private void removeDeclaration(MemberNode def, MemberNode decl) {
        if (def.getLogicalOwnerName().equals(decl.getLogicalOwnerName()) && def.getLogicalName().equals(decl.getLogicalName())) {
            decl.removeFromParent();
        }
    }
}

