/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.IScopeListener;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionDeclNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionDefNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FunctionNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.MemberNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.NamespaceNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDeclNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeDefNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.TypeNode;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;

public class ScopedASTVisitor
extends ASTVisitor {
    protected AbstractNode scopeNode;
    AbstractTreeBuilder builder;
    private Collection<IScopeListener> listeners = new ArrayList<IScopeListener>();

    public ScopedASTVisitor(AbstractNode scopeNode, AbstractTreeBuilder builder) {
        this.scopeNode = scopeNode;
        this.builder = builder;
        this.shouldVisitNamespaces = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarators = true;
    }

    public void add(IScopeListener listener) {
        this.listeners.add(listener);
    }

    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        this.scopeNode = this.builder.addChild(this.scopeNode, new NamespaceNode(namespaceDefinition));
        return super.visit(namespaceDefinition);
    }

    public int leave(ICPPASTNamespaceDefinition namespaceDefinition) {
        this.scopeNode = this.scopeNode.getParent();
        return super.leave(namespaceDefinition);
    }

    public int visit(IASTDeclaration declaration) {
        if (declaration instanceof ICPPASTFunctionDefinition) {
            this.scopeNode = this.builder.addChild(this.scopeNode, new FunctionDefNode((ICPPASTFunctionDefinition)declaration));
        }
        return super.visit(declaration);
    }

    public int leave(IASTDeclaration declaration) {
        if (declaration instanceof ICPPASTFunctionDefinition) {
            for (IScopeListener listener : this.listeners) {
                listener.leaving((MemberNode)this.scopeNode);
            }
            this.scopeNode = this.scopeNode.getParent();
        }
        return super.leave(declaration);
    }

    public int visit(IASTDeclarator declarator) {
        if (declarator instanceof ICPPASTFunctionDeclarator && !(declarator.getParent() instanceof ICPPASTFunctionDefinition)) {
            if (declarator.getChildren().length > 0 && declarator.getChildren()[0] instanceof IASTImplicitNameOwner) {
                return 1;
            }
            if (!(this.scopeNode instanceof FunctionNode)) {
                this.scopeNode = this.builder.addChild(this.scopeNode, new FunctionDeclNode((ICPPASTFunctionDeclarator)declarator));
                if (!(this.scopeNode instanceof FunctionNode)) {
                    return 1;
                }
                return super.visit(declarator);
            }
            return 1;
        }
        return super.visit(declarator);
    }

    public int leave(IASTDeclarator declarator) {
        if (declarator instanceof ICPPASTFunctionDeclarator && (this.scopeNode instanceof FunctionDeclNode || this.scopeNode instanceof FunctionDefNode) && !(declarator.getParent() instanceof ICPPASTFunctionDefinition) && !(declarator.getParent() instanceof ICPPASTLambdaExpression)) {
            for (IScopeListener listener : this.listeners) {
                listener.leaving((MemberNode)this.scopeNode);
            }
            this.scopeNode = this.scopeNode.getParent();
        }
        return super.leave(declarator);
    }

    public int visit(IASTDeclSpecifier declSpec) {
        boolean scopeChanged = false;
        String oldScope = this.scopeNode.getScopeName();
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            this.scopeNode = this.builder.addChild(this.scopeNode, new TypeDefNode((ICPPASTCompositeTypeSpecifier)declSpec));
            if (oldScope.equals(this.scopeNode.getScopeName())) {
                return 1;
            }
            scopeChanged = true;
        }
        if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            this.scopeNode = this.builder.addChild(this.scopeNode, new TypeDeclNode((ICPPASTElaboratedTypeSpecifier)declSpec));
            if (oldScope.equals(this.scopeNode.getScopeName())) {
                return 1;
            }
            scopeChanged = true;
        }
        if (scopeChanged) {
            for (IScopeListener listener : this.listeners) {
                listener.visiting(this.scopeNode);
            }
        }
        return super.visit(declSpec);
    }

    public int leave(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
            for (IScopeListener listener : this.listeners) {
                listener.leaving((TypeNode)this.scopeNode);
            }
            this.scopeNode = this.scopeNode.getParent();
        }
        if (declSpec instanceof ICPPASTElaboratedTypeSpecifier) {
            this.scopeNode = this.scopeNode.getParent();
        }
        return super.leave(declSpec);
    }
}

