/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import java.io.PrintStream;

public class TreePrinter {
    public static final int labelColumnWidth = 30;
    public static final int valueColumnWidth = 15;

    private static void printTree(AbstractNode node, int level, PrintStream out, AbstractMetric ... metrics) {
        level = Math.max(0, level);
        String nodeLabel = node.toString();
        int labelColumnFillCount = 30 - 2 * level - nodeLabel.length();
        String metricColumnValues = TreePrinter.generateMetricColumns(node, metrics);
        if (labelColumnFillCount < 0) {
            nodeLabel = nodeLabel.substring(Math.max(0, -labelColumnFillCount), nodeLabel.length());
        }
        labelColumnFillCount = Math.max(0, labelColumnFillCount);
        if (level == 0) {
            out.printf("[metric columns:", new Object[0]);
            AbstractMetric[] abstractMetricArray = metrics;
            int n = metrics.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractMetric metric = abstractMetricArray[n2];
                out.printf(" '%s'", metric.getName());
                ++n2;
            }
            out.printf("]", new Object[0]);
        }
        out.printf("\n%s %s %s %s", TreePrinter.repeatString("  ", level), nodeLabel, TreePrinter.repeatString(" ", labelColumnFillCount), metricColumnValues);
        for (AbstractNode n : node.getChildren()) {
            TreePrinter.printTree(n, level + 1, out, metrics);
        }
    }

    private static String generateMetricColumns(AbstractNode node, AbstractMetric ... metrics) {
        StringBuilder out = new StringBuilder();
        AbstractMetric[] abstractMetricArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMetric metric = abstractMetricArray[n2];
            int aggregatedValue = node.getValueOf((AbstractMetric)metric).aggregatedValue;
            int nodeValue = node.getValueOf((AbstractMetric)metric).nodeValue;
            out.append(String.format("%s (%s)%s", aggregatedValue, nodeValue, TreePrinter.repeatString(" ", 15 - (String.valueOf(aggregatedValue) + nodeValue).length())));
            ++n2;
        }
        return out.toString();
    }

    public static void printTree(AbstractNode node, AbstractMetric ... metricsToPrint) {
        TreePrinter.printTree(node, 0, System.out, metricsToPrint);
        System.out.println("\n----------");
    }

    public static void printTree(AbstractNode node, PrintStream out, AbstractMetric ... metricsToPrint) {
        TreePrinter.printTree(node, 0, out, metricsToPrint);
        out.println("\n----------");
    }

    private static String repeatString(String str, int times) {
        return times == 0 ? "" : String.format("%0" + times + "d", 0).replace("0", str);
    }
}

