/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model.converters;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetricChecker;
import ch.hsr.ifs.cdt.metriculator.model.converters.ModelToXMLConverter;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.AbstractChecker;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.param.BasicProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetriculatorToXMLConverter
extends ModelToXMLConverter {
    @Override
    public void convert(AbstractNode node, Collection<AbstractMetric> metrics) {
        super.convert(node, metrics);
        this.createProblemPreferencesElements(metrics);
    }

    private void createProblemPreferencesElements(Collection<AbstractMetric> metrics) {
        if (metrics == null) {
            return;
        }
        Node prefElement = this.xml.propertiesElement.appendChild(this.xml.doc.createElement("preferences"));
        for (AbstractMetric m : metrics) {
            Element metricPrefElement = this.xml.doc.createElement(m.getName().toLowerCase());
            prefElement.appendChild(metricPrefElement);
            AbstractMetricChecker checker = m.getChecker();
            for (IProblem problem : this.getProblemsFor((AbstractChecker)checker)) {
                metricPrefElement.setAttribute("longname", problem.getName());
                metricPrefElement.setAttribute("shortname", m.getName());
                Element problemElement = this.xml.doc.createElement("problem");
                problemElement.setAttribute("message", problem.getMessagePattern());
                metricPrefElement.appendChild(problemElement);
                IProblemPreference[] iProblemPreferenceArray = ((MapProblemPreference)problem.getPreference()).getChildDescriptors();
                int n = iProblemPreferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblemPreference pref = iProblemPreferenceArray[n2];
                    if (pref instanceof BasicProblemPreference) {
                        Element problemPrefElement = this.xml.doc.createElement(pref.getKey());
                        Object prefValue = pref.getValue();
                        problemPrefElement.setTextContent(prefValue.toString());
                        problemElement.appendChild(problemPrefElement);
                    }
                    ++n2;
                }
            }
        }
    }

    private Collection<IProblem> getProblemsFor(AbstractChecker checker) {
        ICheckersRegistry checkersRegistry = CodanRuntime.getInstance().getCheckersRegistry();
        IProblem[] profileProblems = checkersRegistry.getWorkspaceProfile().getProblems();
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        for (IProblem p : checkersRegistry.getRefProblems((IChecker)checker)) {
            IProblem[] iProblemArray = profileProblems;
            int n = profileProblems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem profileProblem = iProblemArray[n2];
                if (profileProblem.getId().equalsIgnoreCase(p.getId())) {
                    problems.add(p);
                }
                ++n2;
            }
        }
        return problems;
    }
}

