/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model.converters;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.converters.IModelConverter;
import ch.hsr.ifs.cdt.metriculator.model.converters.MetriculatorXMLDocument;
import ch.hsr.ifs.cdt.metriculator.model.converters.XMLBuilderVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;

public class ModelToXMLConverter
implements IModelConverter<MetriculatorXMLDocument> {
    protected MetriculatorXMLDocument xml;

    @Override
    public void convert(AbstractNode node, Collection<AbstractMetric> metrics) {
        if (metrics == null) {
            metrics = new ArrayList<AbstractMetric>();
        }
        this.xml = new MetriculatorXMLDocument();
        XMLBuilderVisitor v = new XMLBuilderVisitor(metrics, this.xml);
        node.accept(v);
    }

    @Override
    public MetriculatorXMLDocument getResult() {
        return this.xml;
    }

    public String getFormattedXML() {
        OutputFormat format = new OutputFormat(this.xml.doc);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        StringWriter out = new StringWriter();
        XMLSerializer serializer = new XMLSerializer(out, format);
        try {
            serializer.serialize(this.xml.doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ((Object)out).toString();
    }
}

