/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model.converters;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.INodeVisitor;
import ch.hsr.ifs.cdt.metriculator.model.converters.MetriculatorXMLDocument;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FolderNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.NamespaceNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.ProjectNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.WorkspaceNode;
import java.util.Collection;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBuilderVisitor
implements INodeVisitor {
    private Collection<AbstractMetric> metrics;
    public MetriculatorXMLDocument xml;
    public Node curr;

    public XMLBuilderVisitor(Collection<AbstractMetric> metrics, MetriculatorXMLDocument xml) {
        this.metrics = metrics;
        this.xml = xml;
        this.curr = this.xml.doc.getDocumentElement();
    }

    private Element createMetricsElement(AbstractNode forNode) {
        Element metrics = this.xml.doc.createElement("metrics");
        for (AbstractMetric m : this.metrics) {
            Element metric = this.xml.doc.createElement(m.getName().toLowerCase());
            int aggregatedValue = forNode.getValueOf((AbstractMetric)m).aggregatedValue;
            metric.setTextContent(Integer.valueOf(aggregatedValue).toString());
            this.applyProblemsOf(m, forNode, metric);
            metrics.appendChild(metric);
        }
        return metrics;
    }

    private void applyProblemsOf(AbstractMetric metric, AbstractNode inNode, Element toElement) {
        Collection<IProblem> problems = metric.getChecker().getProblemsFor(inNode);
        if (problems != null) {
            for (IProblem p : problems) {
                if (p.getSeverity() == CodanSeverity.Warning) {
                    toElement.setAttribute("problem-state", "warning");
                    continue;
                }
                if (p.getSeverity() == CodanSeverity.Error) {
                    toElement.setAttribute("problem-state", "error");
                    continue;
                }
                if (p.getSeverity() != CodanSeverity.Info) continue;
                toElement.setAttribute("problem-state", "none");
            }
        }
    }

    public void processChildrenOf(AbstractNode parent, Node parentXmlNode) {
        this.curr = parentXmlNode;
        for (AbstractNode child : parent.getChildren()) {
            child.accept(this);
        }
        this.curr = parentXmlNode.getParentNode();
    }

    @Override
    public void visit(WorkspaceNode n) {
        this.processChildrenOf(n, this.curr);
    }

    @Override
    public void visit(ProjectNode n) {
        this.createNodeXMLElement(n);
    }

    @Override
    public void visit(FolderNode n) {
        this.createNodeXMLElement(n);
    }

    @Override
    public void visit(AbstractNode n) {
        this.createNodeXMLElement(n);
    }

    @Override
    public void visit(NamespaceNode n) {
        if (n.isAnonymous()) {
            this.createNodeXMLElement(n, "anonymous");
        } else {
            this.createNodeXMLElement(n);
        }
    }

    private void createNodeXMLElement(AbstractNode n, String label) {
        Element e = this.xml.doc.createElement("node");
        e.setAttribute("type", n.getClass().getSimpleName().toLowerCase());
        e.setAttribute("label", label);
        e.appendChild(this.createMetricsElement(n));
        this.curr.appendChild(e);
        this.processChildrenOf(n, e);
    }

    private void createNodeXMLElement(AbstractNode n) {
        this.createNodeXMLElement(n, n.getScopeName());
    }
}

