/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model.nodes;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.INodeVisitorAccepter;
import ch.hsr.ifs.cdt.metriculator.model.nodes.CompositeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.core.resources.IFile;

public abstract class AbstractNode
implements Cloneable,
INodeVisitorAccepter {
    private static final String EMPTY_STRING = "";
    protected String scopeName;
    protected AbstractNode parent;
    private String hybridId;
    private EditorInfo editorInfo;
    private String cachedPath;
    private HashMap<String, AbstractNode> children = new HashMap();
    private ArrayList<AbstractNode> orderedChildren = new ArrayList();
    private HashMap<String, CompositeValue> metricValues = new HashMap();

    protected AbstractNode(String scopeUniqueName) {
        this.setScopeName(scopeUniqueName);
    }

    public EditorInfo getEditorInfo() {
        return this.editorInfo;
    }

    protected AbstractNode(String scopeUniqueName, IASTNode astNode) {
        this(scopeUniqueName);
        if (astNode != null) {
            this.editorInfo = new EditorInfo(astNode);
        }
    }

    public Collection<AbstractNode> getChildren() {
        return Collections.unmodifiableCollection(this.orderedChildren);
    }

    public AbstractNode getParent() {
        return this.parent;
    }

    public AbstractNode add(AbstractNode childNode) {
        childNode.parent = this;
        this.children.put(childNode.getHybridId(), childNode);
        this.orderedChildren.add(childNode);
        childNode.resetPath();
        return childNode;
    }

    public void resetPath() {
        this.cachedPath = null;
    }

    public AbstractNode getChildBy(String hybridId) {
        return this.children.get(hybridId);
    }

    public <T extends AbstractNode> Collection<T> getChildren(Class<T> type) {
        ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
        for (AbstractNode n : this.children.values()) {
            if (!type.isInstance(n)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public CompositeValue getValueOrDefaultOf(String metricKey) {
        CompositeValue metricValue = this.metricValues.get(metricKey);
        if (metricValue == null) {
            metricValue = new CompositeValue();
            this.metricValues.put(metricKey, metricValue);
        }
        return metricValue;
    }

    public CompositeValue getValueOf(AbstractMetric metric) {
        if (!metric.useCachedValue) {
            metric.aggregate(this);
        }
        return this.metricValues.get(metric.getKey());
    }

    public String getScopeUniqueName() {
        return this.scopeName;
    }

    protected void setScopeName(String scopeName) {
        this.scopeName = scopeName.replaceAll("[\n\r\t]", EMPTY_STRING).replaceAll("\\s{2,}", EMPTY_STRING);
    }

    public String getScopeName() {
        return this.scopeName;
    }

    private String getPath(StringBuilder pathBuilder) {
        if (pathBuilder.length() == 0) {
            pathBuilder.insert(0, this.getScopeUniqueName());
        } else {
            pathBuilder.insert(0, "#").insert(0, this.getScopeUniqueName());
        }
        if (this.parent != null) {
            return this.parent.getPath(pathBuilder);
        }
        return pathBuilder.toString();
    }

    public String getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = this.getPath(new StringBuilder(EMPTY_STRING));
        }
        return this.cachedPath;
    }

    public int getAggregatedValueOf(AbstractMetric abstractMetric) {
        return this.getValueOf((AbstractMetric)abstractMetric).aggregatedValue;
    }

    public int getNodeValue(String key) {
        return this.getValueOrDefaultOf((String)key).nodeValue;
    }

    public void setNodeValue(String key, int value) {
        this.getValueOrDefaultOf((String)key).nodeValue = value;
    }

    public String toString() {
        return this.getScopeName();
    }

    public AbstractNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.getParent().getRoot();
    }

    public String getHybridId() {
        return this.hybridId;
    }

    public void setHybridId(String hybridId) {
        this.hybridId = hybridId;
        this.resetPath();
    }

    public void removeFromParent() {
        this.parent.removeChild(this);
        this.resetPath();
    }

    public void removeChild(AbstractNode node) {
        this.children.remove(node.hybridId);
        this.orderedChildren.remove(node);
        node.resetPath();
    }

    public AbstractNode shallowClone() {
        try {
            AbstractNode clone = (AbstractNode)super.clone();
            clone.parent = this.parent;
            clone.children = new HashMap();
            clone.orderedChildren = new ArrayList();
            clone.metricValues = new HashMap();
            for (String k : this.metricValues.keySet()) {
                clone.metricValues.put(k, CompositeValue.copy(this.metricValues.get(k)));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public void addNodeValuesFrom(AbstractNode copy) {
        for (String metricKey : this.metricValues.keySet()) {
            this.metricValues.get((Object)metricKey).nodeValue += copy.metricValues.get((Object)metricKey).nodeValue;
        }
    }

    public abstract String getIconPath();

    public static class EditorInfo {
        private String filePath = "";
        private int nodeOffSet;
        private int nodeLength;
        private int endingLineNumber;
        private int startingLineNumber;
        private int nodeOffSetStart;
        private int nodeOffsetEnd;
        private boolean isEclosedInMacroExpansion;

        public EditorInfo(IASTNode astNode) {
            this.prepareFilePath(astNode);
            this.prepareNodeLocations(astNode);
            this.prepareProblemLocation(astNode);
        }

        public String getFilePath() {
            return this.filePath;
        }

        public int getNodeOffset() {
            return this.nodeOffSet;
        }

        public int getNodeLength() {
            return this.nodeLength;
        }

        public IProblemLocation createAndGetProblemLocation(IFile file) {
            IProblemLocationFactory locFactory = CodanRuntime.getInstance().getProblemLocationFactory();
            if (this.isEclosedInMacroExpansion || this.startingLineNumber == this.endingLineNumber) {
                return locFactory.createProblemLocation(file, this.nodeOffSetStart, this.nodeOffsetEnd, this.startingLineNumber);
            }
            return locFactory.createProblemLocation(file, this.startingLineNumber);
        }

        private void prepareFilePath(IASTNode astNode) {
            this.filePath = astNode.getTranslationUnit().getFilePath();
        }

        private void prepareNodeLocations(IASTNode astNode) {
            this.nodeOffSet = astNode.getNodeLocations()[0].getNodeOffset();
            this.nodeLength = astNode.getNodeLocations()[0].getNodeLength();
        }

        private void prepareProblemLocation(IASTNode astNode) {
            IASTFileLocation astLocation = astNode.getFileLocation();
            this.startingLineNumber = astLocation.getStartingLineNumber();
            if (EditorInfo.isEnclosedInMacroExpansion(astNode) && astNode instanceof IASTName) {
                this.isEclosedInMacroExpansion = true;
                IASTImageLocation imageLocation = ((IASTName)astNode).getImageLocation();
                if (imageLocation != null) {
                    this.nodeOffSetStart = imageLocation.getNodeOffset();
                    this.nodeOffsetEnd = this.nodeOffSetStart + imageLocation.getNodeLength();
                    return;
                }
            }
            this.endingLineNumber = astLocation.getEndingLineNumber();
            if (this.startingLineNumber == this.endingLineNumber) {
                this.nodeOffSetStart = astLocation.getNodeOffset();
                this.nodeOffsetEnd = this.nodeOffSetStart + astLocation.getNodeLength();
                return;
            }
        }

        private static boolean isEnclosedInMacroExpansion(IASTNode node) {
            IASTNodeLocation[] nodeLocations = node.getNodeLocations();
            return nodeLocations.length == 1 && nodeLocations[0] instanceof IASTMacroExpansionLocation;
        }
    }
}

