/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model.nodes;

import ch.hsr.ifs.cdt.metriculator.model.INodeVisitor;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.ProjectNode;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileNode
extends AbstractNode {
    private String projectRelativePath;
    private boolean isHeaderUnit = false;

    public FileNode(String name) {
        super(name);
    }

    public FileNode(IASTTranslationUnit tu, String filename) {
        super(filename, (IASTNode)tu);
        if (tu != null) {
            this.isHeaderUnit = tu.isHeaderUnit();
        }
    }

    @Override
    public void accept(INodeVisitor v) {
        v.visit(this);
    }

    public boolean isHeaderUnit() {
        return this.isHeaderUnit;
    }

    @Override
    public String toString() {
        if (this.parent instanceof ProjectNode && ((ProjectNode)this.parent).getProject() != null) {
            if (((ProjectNode)this.parent).getProject().getLocation() != null && this.projectRelativePath == null) {
                this.projectRelativePath = PathUtil.getProjectRelativePath((IPath)new Path(this.getScopeUniqueName()), (IProject)((ProjectNode)this.parent).getProject()).setDevice(null).toOSString();
            }
            return this.projectRelativePath != null ? this.projectRelativePath : super.toString();
        }
        return super.toString();
    }

    @Override
    public String getIconPath() {
        if (this.isHeaderUnit()) {
            return "icons/obj16/h_file_obj.gif";
        }
        return "icons/obj16/c_file_obj.gif";
    }
}

