/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.model.nodes;

import ch.hsr.ifs.cdt.metriculator.model.nodes.LogicNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public abstract class MemberNode
extends LogicNode {
    protected boolean isMember = false;
    protected String logicalName = "";
    protected String logicalOwnerName = "";
    protected IIndexBinding indexBinding;

    protected MemberNode(String scopeUniqueName) {
        super(scopeUniqueName);
    }

    protected MemberNode(String scopeUniqueName, IASTNode astNode) {
        super(scopeUniqueName, astNode);
        if (this.prepareBinding(astNode)) {
            this.prepareOwnership(this.indexBinding.getOwner(), astNode.getTranslationUnit());
        }
        this.prepareIsFriend(astNode);
    }

    protected abstract void prepareIsFriend(IASTNode var1);

    protected abstract IASTName getASTName(IASTNode var1);

    protected boolean prepareBinding(IASTNode astNode) {
        IASTName name = this.getASTName(astNode);
        IIndex index = astNode.getTranslationUnit().getIndex();
        this.indexBinding = index.adaptBinding(name.resolveBinding());
        return this.indexBinding != null;
    }

    public IIndexBinding getIndexBinding() {
        return this.indexBinding;
    }

    public void clearBindings() {
        this.indexBinding = null;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public String getLogicalOwnerName() {
        return this.logicalOwnerName;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    protected void prepareOwnership(IIndexBinding owner, IASTTranslationUnit tu) {
        this.logicalName = this.indexBinding.toString();
        if (owner != null) {
            this.logicalOwnerName = this.buildLogicalOwnerName((IBinding)owner, tu);
            if (owner instanceof ICompositeType) {
                this.isMember = true;
                this.indexBinding = null;
            }
        }
    }

    protected String buildLogicalOwnerName(IBinding owner, IASTTranslationUnit tu) {
        if (owner == null) {
            return "";
        }
        IBinding newOwner = null;
        IASTNode node = null;
        IASTName[] declarationsInAST = tu.getDeclarationsInAST(owner);
        if (declarationsInAST.length > 0) {
            node = declarationsInAST[0].getParent();
            newOwner = CPPVisitor.findNameOwner((IASTName)declarationsInAST[0], (boolean)true);
            if (newOwner == null) {
                if (this.isAnonymousNamespace(node)) {
                    return String.valueOf(owner.getName().toString()) + node.hashCode();
                }
                return owner.getName().toString();
            }
        }
        return String.valueOf(this.buildLogicalOwnerName(newOwner, tu)) + "#" + owner.getName() + (this.isAnonymousNamespace(node) ? Integer.valueOf(node.hashCode()) : "");
    }

    private boolean isAnonymousNamespace(IASTNode node) {
        return node instanceof ICPPASTNamespaceDefinition && ((ICPPASTNamespaceDefinition)node).getName().toString().isEmpty();
    }
}

