/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.report;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.converters.MetriculatorToXMLConverter;
import ch.hsr.ifs.cdt.metriculator.model.converters.MetriculatorXMLDocument;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.report.FileReportGenerator;
import ch.hsr.ifs.cdt.metriculator.report.ReportConfigurationStore;
import ch.hsr.ifs.cdt.metriculator.report.views.ConfigurationView;
import ch.hsr.ifs.cdt.metriculator.report.views.FileReportConfigurationView;
import ch.hsr.ifs.cdt.metriculator.report.views.HTMLReportConfigurationView;
import ch.hsr.ifs.cdt.metriculator.report.views.IConfigurableReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLReportGenerator
extends FileReportGenerator
implements IConfigurableReport {
    private static final String RESOURCES_BASE_PATH = "/export-resources/reports/html/";
    public static final String CONFIG_REPORT = "report_template";
    public String theme = "simple";
    public String report = "static";

    @Override
    public void run(ReportConfigurationStore configStore, AbstractNode root, Collection<AbstractMetric> metrics) throws Exception {
        this.readConfiguration(configStore);
        MetriculatorToXMLConverter x = new MetriculatorToXMLConverter();
        x.convert(root, metrics);
        MetriculatorXMLDocument doc = x.getResult();
        this.injectProperties(doc);
        this.export_to_dir = this.export_to_dir.append(this.report);
        this.copyResourcesTo(this.export_to_dir);
        IPath xmlFilename = this.export_to_dir.append("model").addFileExtension("xml");
        String xml = x.getFormattedXML();
        this.writeTo(xmlFilename, xml);
        IPath htmlFilename = this.export_to_dir.append("index").addFileExtension("html");
        StreamSource xmlStream = new StreamSource(new File(xmlFilename.toOSString()));
        StreamSource xslStream = new StreamSource(this.getProjectFile(RESOURCES_BASE_PATH + this.report + "/html.xslt"));
        this.transform(xmlStream, xslStream, new StreamResult(htmlFilename.toOSString()));
        this.selectPathInOSFileBrowser(htmlFilename);
    }

    private void injectProperties(MetriculatorXMLDocument xml) {
        Node propEl = xml.propertiesElement;
        Element themeEl = xml.doc.createElement("theme");
        themeEl.setAttribute("name", this.theme);
        propEl.appendChild(themeEl);
    }

    private void transform(StreamSource xmlStream, StreamSource xslStream, StreamResult result) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(xslStream);
            Transformer transformer = template.newTransformer();
            transformer.transform(xmlStream, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void copyResourcesTo(IPath export_location) {
        HTMLReportGenerator.copyBundleFolder(RESOURCES_BASE_PATH + this.report, export_location);
    }

    @Override
    public List<ConfigurationView> getConfigurationViews(ReportConfigurationStore config) {
        ArrayList<ConfigurationView> views = new ArrayList<ConfigurationView>();
        views.add(new FileReportConfigurationView(config));
        views.add(new HTMLReportConfigurationView(config));
        return views;
    }

    public void readConfiguration(ReportConfigurationStore configuration) {
        this.report = (String)configuration.get(this.getClass(), CONFIG_REPORT, this.report);
        this.export_to_dir = (IPath)configuration.get(FileReportGenerator.class, "export_path", this.export_to_dir);
    }
}

