/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.report;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.converters.ModelToASCIIConverter;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.report.FileReportGenerator;
import ch.hsr.ifs.cdt.metriculator.report.ReportConfigurationStore;
import ch.hsr.ifs.cdt.metriculator.report.views.ConfigurationView;
import ch.hsr.ifs.cdt.metriculator.report.views.FileReportConfigurationView;
import ch.hsr.ifs.cdt.metriculator.report.views.IConfigurableReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TextReportGenerator
extends FileReportGenerator
implements IConfigurableReport {
    @Override
    public void run(ReportConfigurationStore configStore, AbstractNode root, Collection<AbstractMetric> metrics) {
        this.readConfiguration(configStore);
        ModelToASCIIConverter a = new ModelToASCIIConverter();
        a.convert(root, metrics);
        IPath textFilename = this.export_to_dir.append("metrics").addFileExtension("txt");
        this.writeTo(textFilename, (String)a.getResult());
        this.selectPathInOSFileBrowser(textFilename);
    }

    @Override
    public List<ConfigurationView> getConfigurationViews(ReportConfigurationStore config) {
        ArrayList<ConfigurationView> views = new ArrayList<ConfigurationView>();
        views.add(new FileReportConfigurationView(config));
        return views;
    }

    public void readConfiguration(ReportConfigurationStore configuration) {
        this.export_to_dir = (IPath)configuration.get(FileReportConfigurationView.class, "export_dir", this.export_to_dir);
        if (this.export_to_dir.isEmpty()) {
            this.export_to_dir = Path.fromOSString((String)System.getProperty("user.home")).append("metriculator-export");
        }
    }
}

