/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.report.views;

import ch.hsr.ifs.cdt.metriculator.report.views.ConfigurationView;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReportConfigurationDialog
extends TitleAreaDialog {
    private List<ConfigurationView> views = null;

    public ReportConfigurationDialog(Shell parentShell, List<ConfigurationView> views) {
        super(parentShell);
        this.views = views;
    }

    public void create() {
        super.create();
        this.setTitle("Report Configuration");
        this.setMessage("Configure your report export settings.", 1);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        for (ConfigurationView view : this.views) {
            view.create(parent);
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 131072;
        parent.setLayoutData((Object)gridData);
        this.createOkButton(parent, 0, "Generate", true);
        Button cancelButton = this.createButton(parent, 1, "Cancel", false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportConfigurationDialog.this.setReturnCode(1);
                ReportConfigurationDialog.this.close();
            }
        });
    }

    protected Button createOkButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ReportConfigurationDialog.this.isValidInput()) {
                    ReportConfigurationDialog.this.okPressed();
                }
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    private boolean isValidInput() {
        boolean valid = true;
        return valid;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

