/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.views;

import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.report.FileReportGenerator;
import ch.hsr.ifs.cdt.metriculator.report.HTMLReportGenerator;
import ch.hsr.ifs.cdt.metriculator.report.ReportConfigurationStore;
import ch.hsr.ifs.cdt.metriculator.report.TextReportGenerator;
import ch.hsr.ifs.cdt.metriculator.report.views.ConfigurationView;
import ch.hsr.ifs.cdt.metriculator.report.views.IConfigurableReport;
import ch.hsr.ifs.cdt.metriculator.report.views.ReportConfigurationDialog;
import ch.hsr.ifs.cdt.metriculator.views.MetriculatorView;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ExportActionMenuCreator
implements IMenuCreator {
    private MenuManager dropDownMenuMgr;
    private MetriculatorView metriculatorView;
    private CompoundContributionItem dropdownMenu = new CompoundContributionItem(){

        private AbstractNode getRootFromActiveView() {
            switch (ExportActionMenuCreator.this.metriculatorView.getViewMode()) {
                case Filtered: {
                    return MetriculatorPluginActivator.getDefault().getFlatTreeBuilder().root;
                }
                case Logical: {
                    return MetriculatorPluginActivator.getDefault().getLogicTreeBuilder().root;
                }
            }
            return MetriculatorPluginActivator.getDefault().getHybridTreeBuilder().root;
        }

        private void runReportGenerator(FileReportGenerator gen) {
            try {
                Collection<AbstractMetric> metrics = MetriculatorPluginActivator.getDefault().getMetrics();
                AbstractNode root = this.getRootFromActiveView();
                ReportConfigurationStore configStore = new ReportConfigurationStore();
                configStore.set(MetriculatorView.class, "instance", ExportActionMenuCreator.this.metriculatorView);
                if (gen instanceof IConfigurableReport) {
                    List<ConfigurationView> views = ((IConfigurableReport)((Object)gen)).getConfigurationViews(configStore);
                    int status = this.createConfigurationView(views).open();
                    if (status != 0) {
                        return;
                    }
                    for (ConfigurationView view : views) {
                        view.writeConfiguration();
                    }
                }
                gen.run(configStore, root, metrics);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private ReportConfigurationDialog createConfigurationView(List<ConfigurationView> views) {
            ReportConfigurationDialog reportConfigurationDialog = new ReportConfigurationDialog(ExportActionMenuCreator.this.metriculatorView.getSite().getShell(), views);
            reportConfigurationDialog.create();
            reportConfigurationDialog.setHelpAvailable(false);
            return reportConfigurationDialog;
        }

        protected IContributionItem[] getContributionItems() {
            LinkedList<ActionContributionItem> itemList = new LinkedList<ActionContributionItem>();
            Action exportHTMLAction = new Action(){

                public void run() {
                    this.runReportGenerator(new HTMLReportGenerator());
                }
            };
            exportHTMLAction.setText("HTML");
            exportHTMLAction.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/elcl16/th_single.gif"));
            itemList.add(new ActionContributionItem((IAction)exportHTMLAction));
            Action exportTextAction = new Action(){

                public void run() {
                    this.runReportGenerator(new TextReportGenerator());
                }
            };
            exportTextAction.setText("ASCII");
            exportTextAction.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/elcl16/segment_edit.gif"));
            itemList.add(new ActionContributionItem((IAction)exportTextAction));
            return itemList.toArray(new IContributionItem[0]);
        }
    };

    public ExportActionMenuCreator(MetriculatorView metriculatorView) {
        this.metriculatorView = metriculatorView;
    }

    private void createDropDownMenuMgr() {
        if (this.dropDownMenuMgr == null) {
            this.dropDownMenuMgr = new MenuManager();
            this.dropDownMenuMgr.add((IContributionItem)this.dropdownMenu);
        }
    }

    public void dispose() {
        if (this.dropDownMenuMgr != null) {
            this.dropDownMenuMgr.dispose();
            this.dropDownMenuMgr = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.createDropDownMenuMgr();
        return this.dropDownMenuMgr.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        this.createDropDownMenuMgr();
        Menu menu = new Menu(parent);
        IContributionItem[] items = this.dropDownMenuMgr.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item;
            IContributionItem newItem = item = items[i];
            if (item instanceof ActionContributionItem) {
                newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
            }
            newItem.fill(menu, -1);
            ++i;
        }
        return menu;
    }
}

