/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.views;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.views.MetricColumnViewerSorter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class MetricColumn {
    static final int DEFAULT_WIDTH = 100;
    static final String DATAKEY_IS_FILLER = "isFiller";
    static final String DATAKEY_COLUMNMETRIC = "metric";

    public static void showColumn(TreeColumn column) {
        column.setWidth(100);
        column.setResizable(true);
    }

    public static void hideColumn(TreeColumn column) {
        column.setWidth(0);
        column.setResizable(false);
    }

    public static void showColumn(TableColumn column) {
        column.setWidth(100);
        column.setResizable(true);
    }

    public static void hideColumn(TableColumn column) {
        column.setWidth(0);
        column.setResizable(false);
    }

    public static TreeColumn createFor(AbstractMetric metric, TreeViewer treeViewer) {
        TreeColumn column = new TreeColumn(treeViewer.getTree(), 131072);
        column.setText(metric.getName());
        column.setToolTipText(metric.getDescription());
        MetricColumn.setMetric(metric, (Widget)column);
        MetricColumnViewerSorter.registerFor(column, treeViewer);
        return column;
    }

    public static TableColumn createFor(AbstractMetric metric, TableViewer tableViewer) {
        TableColumn column = new TableColumn(tableViewer.getTable(), 131072);
        column.setText(metric.getName());
        column.setToolTipText(metric.getDescription());
        MetricColumn.setMetric(metric, (Widget)column);
        MetricColumnViewerSorter.registerFor(column, tableViewer);
        return column;
    }

    public static AbstractMetric getMetric(Widget column) {
        return (AbstractMetric)column.getData(DATAKEY_COLUMNMETRIC);
    }

    public static void setMetric(AbstractMetric metric, Widget column) {
        column.setData(DATAKEY_COLUMNMETRIC, (Object)metric);
    }

    public static void createFillerColumnOnce(Tree tree) {
        if (MetricColumn.isWindows()) {
            return;
        }
        if (MetricColumn.hasFillerColumn((Item[])tree.getColumns())) {
            return;
        }
        TreeColumn column = new TreeColumn(tree, 131072);
        column.setMoveable(false);
        column.setResizable(true);
        column.setWidth(10);
        column.setData(DATAKEY_IS_FILLER, (Object)true);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "unknown").toLowerCase().indexOf("windows") >= 0;
    }

    public static void createFillerColumnOnce(Table table) {
        if (MetricColumn.isWindows()) {
            return;
        }
        if (MetricColumn.hasFillerColumn((Item[])table.getColumns())) {
            return;
        }
        TableColumn column = new TableColumn(table, 131072);
        column.setMoveable(false);
        column.setResizable(true);
        column.setWidth(10);
        column.setData(DATAKEY_IS_FILLER, (Object)true);
    }

    private static boolean hasFillerColumn(Item ... items) {
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item column = itemArray[n2];
            if (MetricColumn.isFiller(column)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isFiller(Item column) {
        return column.getData(DATAKEY_IS_FILLER) != null && (Boolean)column.getData(DATAKEY_IS_FILLER) != false;
    }
}

