/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.views;

import ch.hsr.ifs.cdt.metriculator.views.MetricColumn;
import ch.hsr.ifs.cdt.metriculator.views.ToggleColumnActionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public final class MetricColumnHeaderMenu {
    private static final String DATAKEY_CURR_COLUMN = "current_column";
    public static MenuManager tableMenuManager = new MenuManager();
    public static MenuManager treeMenuManager = new MenuManager();

    public static void setCurrColumn(Menu menu, Item column) {
        menu.setData(DATAKEY_CURR_COLUMN, (Object)column);
    }

    public static Item getCurrColumn(Menu menu) {
        return (Item)menu.getData(DATAKEY_CURR_COLUMN);
    }

    public static Menu create(Shell shell, final Tree treeObj) {
        treeMenuManager.add((IContributionItem)new Separator("additions"));
        treeMenuManager.add((IContributionItem)new Separator());
        final Menu headerMenu = treeMenuManager.createContextMenu((Control)treeObj);
        treeObj.setMenu(headerMenu);
        treeObj.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                boolean inMetricColumn;
                Point treeRelativePoint = Display.getDefault().map(null, (Control)treeObj, new Point(event.x, event.y));
                Rectangle clientArea = treeObj.getClientArea();
                boolean inHeaderArea = clientArea.y <= treeRelativePoint.y && treeRelativePoint.y < clientArea.y + treeObj.getHeaderHeight();
                int selectedColIndex = this.getColumnIndexAt(treeRelativePoint.x);
                boolean bl = inMetricColumn = inHeaderArea && selectedColIndex > 0 && !MetricColumn.isFiller((Item)treeObj.getColumn(selectedColIndex));
                if (inMetricColumn) {
                    MetricColumnHeaderMenu.setCurrColumn(headerMenu, (Item)treeObj.getColumn(selectedColIndex));
                } else {
                    event.doit = false;
                }
            }

            private int getColumnIndexAt(int offsetLeft) {
                int colWidthsTotal = 0;
                int colIndex = -1;
                TreeColumn[] treeColumnArray = treeObj.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn col = treeColumnArray[n2];
                    ++colIndex;
                    if ((colWidthsTotal += col.getWidth()) > offsetLeft) {
                        return colIndex;
                    }
                    ++n2;
                }
                return -1;
            }
        });
        treeObj.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                headerMenu.dispose();
            }
        });
        return headerMenu;
    }

    public static Menu create(Shell shell, final Table tableObj) {
        tableMenuManager.add((IContributionItem)new Separator("additions"));
        final Menu headerMenu = tableMenuManager.createContextMenu((Control)tableObj);
        tableObj.setMenu(headerMenu);
        tableObj.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                boolean inMetricColumn;
                Point treeRelativePoint = Display.getDefault().map(null, (Control)tableObj, new Point(event.x, event.y));
                Rectangle clientArea = tableObj.getClientArea();
                boolean inHeaderArea = clientArea.y <= treeRelativePoint.y && treeRelativePoint.y < clientArea.y + tableObj.getHeaderHeight();
                int selectedColIndex = this.getColumnIndexAt(treeRelativePoint.x);
                boolean bl = inMetricColumn = inHeaderArea && selectedColIndex > 0 && !MetricColumn.isFiller((Item)tableObj.getColumn(selectedColIndex));
                if (inMetricColumn) {
                    MetricColumnHeaderMenu.setCurrColumn(headerMenu, (Item)tableObj.getColumn(selectedColIndex));
                } else {
                    event.doit = false;
                }
            }

            private int getColumnIndexAt(int offsetLeft) {
                int colWidthsTotal = 0;
                int colIndex = -1;
                TableColumn[] tableColumnArray = tableObj.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn col = tableColumnArray[n2];
                    ++colIndex;
                    if ((colWidthsTotal += col.getWidth()) > offsetLeft) {
                        return colIndex;
                    }
                    ++n2;
                }
                return -1;
            }
        });
        tableObj.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                headerMenu.dispose();
            }
        });
        return headerMenu;
    }

    public static void updateItemSelections(MenuManager menu) {
        IContributionItem[] iContributionItemArray = menu.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ToggleColumnActionItem) {
                ((ToggleColumnActionItem)item).toggleVisibility();
            }
            ++n2;
        }
        menu.isDirty();
    }
}

