/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.views;

import ch.hsr.ifs.cdt.metriculator.JobObservable;
import ch.hsr.ifs.cdt.metriculator.MetriculatorPluginActivator;
import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.AbstractTreeBuilder;
import ch.hsr.ifs.cdt.metriculator.model.NodeFilter;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.FileNode;
import ch.hsr.ifs.cdt.metriculator.model.nodes.LogicNode;
import ch.hsr.ifs.cdt.metriculator.views.AwtSwtColorConverter;
import ch.hsr.ifs.cdt.metriculator.views.ExportActionMenuCreator;
import ch.hsr.ifs.cdt.metriculator.views.ITagCloudDataProvider;
import ch.hsr.ifs.cdt.metriculator.views.MetricColumn;
import ch.hsr.ifs.cdt.metriculator.views.MetricColumnHeaderMenu;
import ch.hsr.ifs.cdt.metriculator.views.NodeViewerFilter;
import ch.hsr.ifs.cdt.metriculator.views.TableColumnViewerSorter;
import ch.hsr.ifs.cdt.metriculator.views.ToggleColumnActionItem;
import ch.hsr.ifs.cdt.metriculator.views.TreeColumnViewerSorter;
import ch.hsr.ifs.cdt.metriculator.views.TreeContentProvider;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.ui.CodanEditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class MetriculatorView
extends ViewPart
implements Observer,
ITagCloudDataProvider {
    private static final int INITIAL_SORT_ORDER = 0;
    private static final int SCOPE_COLUMN_DEFAULT_WIDTH = 160;
    private static final String SCOPE_COLUMN_TITLE = "Scope";
    public static final String VIEW_ID = "ch.hsr.ifs.cdt.metriculator.views.MetriculatorView";
    public static final String TABLE_COLUMN_HEADER_MENU_ID = "ch.hsr.ifs.cdt.metriculator.views.MetriculatorView.menuTableColumnHeader";
    private HashMap<AbstractMetric, ToggleColumnActionItem<TreeColumn>> metricsTreeColumnActions = new HashMap();
    private HashMap<AbstractMetric, ToggleColumnActionItem<TableColumn>> metricsTableColumnActions = new HashMap();
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private NodeViewerFilter viewerFilter;
    private IAction actionHybridView;
    private IAction actionExpandAll;
    private IAction actionCollapseAll;
    private IAction actionFilterComposite;
    private IAction actionLogicalView;
    private IAction actionFilterFunction;
    private IAction actionFilterNamespace;
    private IAction actionFilterFile;
    private AbstractTreeBuilder currTreeBuilder;
    private ViewMode viewMode;
    private Menu tableHeaderMenu;
    private Composite treeComposite;
    private Composite tableComposite;
    private Composite parentComposite;
    private StructuredViewer activeViewer;
    private StackLayout stackLayout;
    private Action actionExport;

    public MetriculatorView() {
        MetriculatorPluginActivator.getDefault().getObservable().addObserver(this);
    }

    public void dispose() {
        MetriculatorPluginActivator.getDefault().getObservable().deleteObserver(this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.stackLayout = new StackLayout();
        parent.setLayout((Layout)this.stackLayout);
        this.parentComposite = parent;
        MetricColumnHeaderMenu.treeMenuManager = new MenuManager();
        MetricColumnHeaderMenu.tableMenuManager = new MenuManager();
        this.createTreeComponents();
        this.createTableComponents();
        this.createActions();
        this.addActionsToMenus();
        this.applyViewMode(ViewMode.Hybrid, null);
        this.updateViewerData();
    }

    private void createTableComponents() {
        this.tableComposite = new Composite(this.parentComposite, this.parentComposite.getStyle());
        this.tableComposite.setLayout((Layout)new FillLayout());
        Table tableObject = new Table(this.tableComposite, 0x10010B00);
        tableObject.setHeaderVisible(true);
        tableObject.setLinesVisible(true);
        this.tableViewer = new TableViewer(tableObject);
        this.tableViewer.addFilter((ViewerFilter)this.viewerFilter);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MetriculatorCellLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        this.addViewerOpenListener((StructuredViewer)this.tableViewer);
        this.createTableHeaderMenu();
        this.createTableLabelColumn();
        this.createAndUpdateMetricTableColumns();
    }

    private void createTreeComponents() {
        this.treeComposite = new Composite(this.parentComposite, this.parentComposite.getStyle());
        this.treeComposite.setLayout((Layout)new FillLayout());
        Tree treeObject = new Tree(this.treeComposite, 0x10010B00);
        treeObject.setHeaderVisible(true);
        treeObject.setLinesVisible(true);
        this.viewerFilter = new NodeViewerFilter();
        this.treeViewer = new TreeViewer(treeObject);
        this.treeViewer.addFilter((ViewerFilter)this.viewerFilter);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MetriculatorCellLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.addViewerOpenListener((StructuredViewer)this.treeViewer);
        this.createTreeHeaderMenu();
        this.createTreeLabelColumn();
        this.createAndUpdateMetricTreeColumns();
    }

    private void bringToFront(Composite container, StructuredViewer viewer) {
        this.stackLayout.topControl = container;
        this.activeViewer = viewer;
        Point p = this.parentComposite.getSize();
        this.parentComposite.setSize(new Point(p.x + 1, p.y));
        this.parentComposite.setSize(p);
    }

    private void createTableLabelColumn() {
        TableColumn colNodes = new TableColumn(this.tableViewer.getTable(), 16384);
        colNodes.setText(SCOPE_COLUMN_TITLE);
        colNodes.setWidth(160);
        colNodes.setMoveable(false);
        colNodes.setResizable(true);
        TableColumnViewerSorter scopeSorter = new TableColumnViewerSorter(this.tableViewer, colNodes){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                AbstractNode p1 = (AbstractNode)e1;
                AbstractNode p2 = (AbstractNode)e2;
                return p1.toString().compareToIgnoreCase(p2.toString());
            }
        };
        scopeSorter.setSorter(scopeSorter, 0);
    }

    private void createTreeLabelColumn() {
        TreeColumn colNodes = new TreeColumn(this.treeViewer.getTree(), 16384);
        colNodes.setAlignment(16384);
        colNodes.setText(SCOPE_COLUMN_TITLE);
        colNodes.setWidth(160);
        colNodes.setMoveable(false);
        colNodes.setResizable(true);
        TreeColumnViewerSorter scopeSorter = new TreeColumnViewerSorter(this.treeViewer, colNodes){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                AbstractNode p1 = (AbstractNode)e1;
                AbstractNode p2 = (AbstractNode)e2;
                return p1.toString().compareToIgnoreCase(p2.toString());
            }
        };
        scopeSorter.setSorter(scopeSorter, 0);
    }

    private void createTreeHeaderMenu() {
        MetricColumnHeaderMenu.create(this.parentComposite.getShell(), this.treeViewer.getTree());
    }

    private void createTableHeaderMenu() {
        this.tableHeaderMenu = MetricColumnHeaderMenu.create(this.parentComposite.getShell(), this.tableViewer.getTable());
        this.getSite().registerContextMenu(TABLE_COLUMN_HEADER_MENU_ID, MetricColumnHeaderMenu.tableMenuManager, (ISelectionProvider)this.tableViewer);
    }

    private void createAndUpdateMetricTreeColumns() {
        ToggleColumnActionItem<TreeColumn> actionItem = null;
        for (AbstractMetric metric : MetriculatorPluginActivator.getDefault().getMetrics()) {
            actionItem = this.metricsTreeColumnActions.get(metric);
            if (actionItem == null) {
                TreeColumn col = MetricColumn.createFor(metric, this.treeViewer);
                actionItem = this.createMetricMenuItemFor(col);
                this.metricsTreeColumnActions.put(metric, actionItem);
            }
            actionItem.toggleVisibility();
        }
        if (actionItem != null) {
            MetricColumn.createFillerColumnOnce(this.treeViewer.getTree());
        }
    }

    private void createAndUpdateMetricTableColumns() {
        ToggleColumnActionItem<TableColumn> actionItem = null;
        for (AbstractMetric metric : MetriculatorPluginActivator.getDefault().getMetrics()) {
            actionItem = this.metricsTableColumnActions.get(metric);
            if (actionItem == null) {
                TableColumn col = MetricColumn.createFor(metric, this.tableViewer);
                actionItem = this.createMetricMenuItemFor(col);
                this.metricsTableColumnActions.put(metric, actionItem);
            }
            actionItem.toggleVisibility();
        }
        if (actionItem != null) {
            MetricColumn.createFillerColumnOnce(this.tableViewer.getTable());
        }
    }

    private ToggleColumnActionItem<TreeColumn> createMetricMenuItemFor(TreeColumn column) {
        ToggleColumnActionItem.ToggleTreeColumnActionContrItem actionItem = new ToggleColumnActionItem.ToggleTreeColumnActionContrItem(column);
        MetricColumnHeaderMenu.treeMenuManager.add((IContributionItem)actionItem);
        return actionItem;
    }

    private ToggleColumnActionItem<TableColumn> createMetricMenuItemFor(TableColumn column) {
        ToggleColumnActionItem.ToggleTableColumnActionContrItem actionItem = new ToggleColumnActionItem.ToggleTableColumnActionContrItem(column);
        MetricColumnHeaderMenu.tableMenuManager.add((IContributionItem)actionItem);
        return actionItem;
    }

    @Override
    public AbstractMetric getMenuMetric() {
        TableColumn selectedCol = (TableColumn)MetricColumnHeaderMenu.getCurrColumn(this.tableHeaderMenu);
        if (selectedCol != null) {
            return MetricColumn.getMetric((Widget)selectedCol);
        }
        return null;
    }

    @Override
    public Collection<AbstractNode> getNodes() {
        Collection<AbstractNode> filteredNodes = this.viewerFilter.getNodeFilter().takeFrom(this.currTreeBuilder.root.getChildren());
        return filteredNodes;
    }

    private void createActions() {
        this.createActionHybridView();
        this.createActionLogicalView();
        this.createActionExpandAll();
        this.createActionCollapseAll();
        this.createActionFilterComposite();
        this.createActionFilterFunction();
        this.createActionFilterNamespace();
        this.createActionFilterFile();
        this.createActionExport();
    }

    private void createActionExport() {
        this.actionExport = new Action("Export"){

            public void runWithEvent(Event e) {
                Menu m;
                IMenuCreator mc = this.getMenuCreator();
                Widget item = e.widget;
                ToolItem ti = (ToolItem)item;
                if (mc != null && (m = mc.getMenu((Control)ti.getParent())) != null) {
                    Point point = item.getDisplay().getCursorLocation();
                    m.setLocation(point.x, point.y);
                    m.setVisible(true);
                    return;
                }
            }
        };
        this.actionExport.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/view16/templates.gif"));
        this.actionExport.setMenuCreator((IMenuCreator)new ExportActionMenuCreator(this));
    }

    private void applyViewMode(ViewMode view, NodeFilter filter) {
        this.viewMode = view;
        this.actionLogicalView.setChecked(false);
        this.actionHybridView.setChecked(false);
        switch (view) {
            case Logical: {
                this.actionLogicalView.setChecked(true);
                this.currTreeBuilder = MetriculatorPluginActivator.getDefault().getLogicTreeBuilder();
                this.applyFilterMode(NodeFilter.none());
                this.bringToFront(this.treeComposite, (StructuredViewer)this.treeViewer);
                break;
            }
            case Hybrid: {
                this.actionHybridView.setChecked(true);
                this.currTreeBuilder = MetriculatorPluginActivator.getDefault().getHybridTreeBuilder();
                this.applyFilterMode(NodeFilter.none());
                this.bringToFront(this.treeComposite, (StructuredViewer)this.treeViewer);
                break;
            }
            case Filtered: {
                if (filter == null) {
                    filter = NodeFilter.none();
                }
                this.applyFilterMode(filter);
                this.bringToFront(this.tableComposite, (StructuredViewer)this.tableViewer);
                break;
            }
        }
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    private void applyFilterMode(NodeFilter filter) {
        this.viewerFilter.setNodeFilter(filter);
        this.actionFilterComposite.setChecked(filter instanceof NodeFilter.CompositeNodeFilter);
        this.actionFilterFile.setChecked(filter instanceof NodeFilter.FileNodeFilter);
        this.actionFilterFunction.setChecked(filter instanceof NodeFilter.FunctionNodeFilter);
        this.actionFilterNamespace.setChecked(filter instanceof NodeFilter.NamespaceNodeFilter);
        if (!(filter instanceof NodeFilter.NoneFilter)) {
            this.currTreeBuilder = MetriculatorPluginActivator.getDefault().getFlatTreeBuilder();
        }
    }

    private void createActionFilterFile() {
        this.actionFilterFile = new Action("File Nodes Only", 2){

            public void run() {
                if (this.isChecked()) {
                    MetriculatorView.this.applyViewMode(ViewMode.Filtered, NodeFilter.file());
                } else {
                    MetriculatorView.this.applyViewMode(ViewMode.Hybrid, NodeFilter.none());
                }
                MetriculatorView.this.updateViewerData();
            }
        };
        this.actionFilterFile.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/obj16/file_obj.gif"));
    }

    private void createActionFilterNamespace() {
        this.actionFilterNamespace = new Action("Namespace Nodes Only", 2){

            public void run() {
                if (this.isChecked()) {
                    MetriculatorView.this.applyViewMode(ViewMode.Filtered, NodeFilter.namespace());
                } else {
                    MetriculatorView.this.applyViewMode(ViewMode.Hybrid, NodeFilter.none());
                }
                MetriculatorView.this.updateViewerData();
            }
        };
        this.actionFilterNamespace.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/obj16/namespace_obj.gif"));
    }

    private void createActionExpandAll() {
        this.actionExpandAll = new Action("Expand All Nodes"){

            public void run() {
                MetriculatorView.this.treeViewer.expandAll();
            }
        };
        this.actionExpandAll.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/elcl16/expandall.gif"));
    }

    private void createActionCollapseAll() {
        this.actionCollapseAll = new Action("collapse All Nodes", MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/elcl16/collapseall.gif")){

            public void run() {
                MetriculatorView.this.treeViewer.collapseAll();
            }
        };
    }

    private void createActionHybridView() {
        this.actionHybridView = new Action("Hybrid View Mode (Files, Folders and Source Code Nodes)", 8){

            public void run() {
                if (this.isChecked()) {
                    MetriculatorView.this.applyViewMode(ViewMode.Hybrid, NodeFilter.none());
                    MetriculatorView.this.updateViewerData();
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.actionHybridView.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/obj16/filesyst.gif"));
    }

    private void createActionLogicalView() {
        this.actionLogicalView = new Action("Logical View Mode (Source Code Nodes Only)", 8){

            public void run() {
                if (this.isChecked()) {
                    MetriculatorView.this.applyViewMode(ViewMode.Logical, NodeFilter.none());
                    MetriculatorView.this.updateViewerData();
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.actionLogicalView.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/view16/class_hi.gif"));
    }

    private void createActionFilterComposite() {
        this.actionFilterComposite = new Action("Composite Nodes (Class / Structs / Union)", 2){

            public void run() {
                if (this.isChecked()) {
                    MetriculatorView.this.applyViewMode(ViewMode.Filtered, NodeFilter.composite());
                } else {
                    MetriculatorView.this.applyViewMode(ViewMode.Hybrid, NodeFilter.none());
                }
                MetriculatorView.this.updateViewerData();
            }
        };
        this.actionFilterComposite.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/obj16/class_obj.gif"));
    }

    private void createActionFilterFunction() {
        this.actionFilterFunction = new Action("Function Nodes Only", 2){

            public void run() {
                if (this.isChecked()) {
                    MetriculatorView.this.applyViewMode(ViewMode.Filtered, NodeFilter.function());
                } else {
                    MetriculatorView.this.applyViewMode(ViewMode.Hybrid, NodeFilter.none());
                }
                MetriculatorView.this.updateViewerData();
            }
        };
        this.actionFilterFunction.setImageDescriptor(MetriculatorPluginActivator.getDefault().getImageDescriptor("icons/obj16/function_obj.gif"));
    }

    private void addActionsToMenus() {
        IContributionManager[] managers;
        IContributionManager[] iContributionManagerArray = managers = new IContributionManager[]{this.getViewSite().getActionBars().getMenuManager(), this.getViewSite().getActionBars().getToolBarManager()};
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionManager manager = iContributionManagerArray[n2];
            manager.add((IContributionItem)new Separator());
            manager.add(this.actionHybridView);
            manager.add(this.actionLogicalView);
            manager.add((IContributionItem)new Separator());
            manager.add(this.actionFilterFile);
            manager.add(this.actionFilterNamespace);
            manager.add(this.actionFilterComposite);
            manager.add(this.actionFilterFunction);
            manager.add((IContributionItem)new Separator());
            manager.add(this.actionExpandAll);
            manager.add(this.actionCollapseAll);
            manager.add((IAction)this.actionExport);
            ++n2;
        }
    }

    private void addViewerOpenListener(StructuredViewer viewer) {
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MetriculatorView.this.openSelectedNode(event.getSelection());
            }
        });
    }

    private void openSelectedNode(ISelection selection) {
        boolean selectionSupportsOpen;
        AbstractNode node = this.getFirstNodeFrom(selection);
        boolean bl = selectionSupportsOpen = node instanceof LogicNode || node instanceof FileNode;
        if (selectionSupportsOpen) {
            AbstractNode.EditorInfo info = node.getEditorInfo();
            String filepath = info.getFilePath();
            IEditorPart editor = null;
            try {
                editor = CodanEditorUtility.openInEditor((String)filepath, null);
                if (editor instanceof ITextEditor && !(node instanceof FileNode)) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    textEditor.selectAndReveal(info.getNodeOffset(), info.getNodeLength());
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private AbstractNode getFirstNodeFrom(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            return (AbstractNode)ssel.iterator().next();
        }
        return null;
    }

    public void setFocus() {
        if (this.activeViewer instanceof TreeViewer) {
            this.treeViewer.getControl().setFocus();
        } else if (this.activeViewer instanceof TableViewer) {
            this.tableViewer.getControl().setFocus();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if ((JobObservable.JobState)((Object)arg) == JobObservable.JobState.JOB_DONE) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MetriculatorView.this.applyCodanFinishedState();
                }
            });
        }
        if ((JobObservable.JobState)((Object)arg) == JobObservable.JobState.JOB_ABOUT_TO_RUN) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MetriculatorView.this.applyCodanStartedState();
                }
            });
        }
    }

    private void applyCodanFinishedState() {
        this.createAndUpdateMetricTreeColumns();
        this.createAndUpdateMetricTableColumns();
        this.applyViewMode(ViewMode.Hybrid, null);
        this.updateViewerData();
        MetricColumnHeaderMenu.updateItemSelections(MetricColumnHeaderMenu.treeMenuManager);
        MetricColumnHeaderMenu.updateItemSelections(MetricColumnHeaderMenu.tableMenuManager);
    }

    private void applyCodanStartedState() {
        this.treeViewer.setInput(null);
        this.tableViewer.setInput(null);
    }

    private void updateViewerData() {
        this.activeViewer.setInput((Object)this.currTreeBuilder.root);
        if (this.activeViewer instanceof TableViewer) {
            int rowCount = ((TableViewer)this.activeViewer).getTable().getItemCount();
            String rowCountString = NumberFormat.getIntegerInstance().format(rowCount);
            this.tableViewer.getTable().getColumn(0).setText(String.format("%s (%s items)", SCOPE_COLUMN_TITLE, rowCountString));
        }
    }

    class MetriculatorCellLabelProvider
    extends CellLabelProvider {
        MetriculatorCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(cell.getElement().toString());
                    cell.setImage(MetriculatorPluginActivator.getDefault().getImageDescriptor(((AbstractNode)cell.getElement()).getIconPath()).createImage());
                    break;
                }
                default: {
                    AbstractMetric metric = MetriculatorView.this.activeViewer instanceof TreeViewer ? MetricColumn.getMetric((Widget)MetriculatorView.this.treeViewer.getTree().getColumn(cell.getColumnIndex())) : MetricColumn.getMetric((Widget)MetriculatorView.this.tableViewer.getTable().getColumn(cell.getColumnIndex()));
                    if (metric == null) break;
                    this.applyProblemsOf(metric, cell);
                    int metricValue = ((AbstractNode)cell.getElement()).getAggregatedValueOf(metric);
                    cell.setText(NumberFormat.getIntegerInstance().format(metricValue));
                }
            }
        }

        private void applyProblemsOf(AbstractMetric metric, ViewerCell toCell) {
            Collection<IProblem> problems = metric.getChecker().getProblemsFor((AbstractNode)toCell.getElement());
            if (problems != null) {
                for (IProblem p : problems) {
                    if (p.getSeverity() == CodanSeverity.Warning) {
                        toCell.setBackground(AwtSwtColorConverter.LIGHT_ORANGE);
                        continue;
                    }
                    if (p.getSeverity() == CodanSeverity.Error) {
                        toCell.setBackground(AwtSwtColorConverter.LIGHT_RED);
                        continue;
                    }
                    if (p.getSeverity() != CodanSeverity.Info) continue;
                    toCell.setBackground(AwtSwtColorConverter.fromAwt(Color.WHITE));
                }
            } else {
                toCell.setBackground(null);
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof AbstractNode) {
                return String.format("'%s' , children: %s", ((AbstractNode)element).getPath(), ((AbstractNode)element).getChildren().size());
            }
            return null;
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 100;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((MetriculatorView)MetriculatorView.this).currTreeBuilder.root.getChildren().toArray();
        }
    }

    public static enum ViewMode {
        Hybrid,
        Logical,
        Filtered;

    }
}

