/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.views;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.views.MetricColumn;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class TableColumnViewerSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private int direction = 0;
    protected TableColumn column;
    protected StructuredViewer viewer;

    public TableColumnViewerSorter(TableViewer tableViewer, TableColumn column) {
        this.column = column;
        this.viewer = tableViewer;
        this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerComparator comparator = TableColumnViewerSorter.this.viewer.getComparator();
                if (comparator != null && comparator == TableColumnViewerSorter.this) {
                    int tdirection = TableColumnViewerSorter.this.direction;
                    if (tdirection == 1) {
                        TableColumnViewerSorter.this.setSorter(TableColumnViewerSorter.this, -1);
                    } else if (tdirection == -1) {
                        TableColumnViewerSorter.this.setSorter(TableColumnViewerSorter.this, 0);
                    }
                } else {
                    TableColumnViewerSorter.this.setSorter(TableColumnViewerSorter.this, 1);
                }
            }
        });
    }

    public void setSorter(TableColumnViewerSorter sorter, int direction) {
        if (direction == 0) {
            this.setNoneSorter();
        } else {
            this.setSorterFor(sorter, direction);
        }
    }

    private void setNoneSorter() {
        this.column.getParent().setSortColumn(null);
        this.column.getParent().setSortDirection(0);
        this.viewer.setComparator(null);
    }

    private void setSorterFor(TableColumnViewerSorter sorter, int direction) {
        this.column.getParent().setSortColumn(this.column);
        sorter.direction = direction;
        if (direction == 1) {
            this.column.getParent().setSortDirection(1024);
        } else {
            this.column.getParent().setSortDirection(128);
        }
        if (this.viewer.getComparator() == sorter) {
            this.viewer.refresh();
        } else {
            this.viewer.setComparator((ViewerComparator)sorter);
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.direction * this.doCompare(viewer, e1, e2);
    }

    protected int doCompare(Viewer viewer, Object e1, Object e2) {
        AbstractNode n1 = (AbstractNode)e1;
        AbstractNode n2 = (AbstractNode)e2;
        AbstractMetric metric = MetricColumn.getMetric((Widget)this.column);
        int val1 = n1.getValueOf((AbstractMetric)metric).aggregatedValue;
        int val2 = n2.getValueOf((AbstractMetric)metric).aggregatedValue;
        return val1 < val2 ? 1 : (val1 == val2 ? 0 : -1);
    }
}

