/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.cdt.metriculator.views.reports;

import ch.hsr.ifs.cdt.metriculator.model.AbstractMetric;
import ch.hsr.ifs.cdt.metriculator.model.converters.MetriculatorToXMLConverter;
import ch.hsr.ifs.cdt.metriculator.model.converters.MetriculatorXMLDocument;
import ch.hsr.ifs.cdt.metriculator.model.nodes.AbstractNode;
import ch.hsr.ifs.cdt.metriculator.views.reports.FileReportGenerator;
import java.io.File;
import java.util.Collection;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLReportGenerator
extends FileReportGenerator {
    private static final String RESOURCES_BASE_PATH = "/export-resources/reports/html/";
    public String theme = "simple";
    public String report = "static";

    public HTMLReportGenerator(IPath export_folder, AbstractNode root, Collection<AbstractMetric> metrics) {
        super(export_folder, root, metrics);
    }

    @Override
    public void run() throws Exception {
        MetriculatorToXMLConverter x = new MetriculatorToXMLConverter();
        x.convert(this.root, this.metrics);
        MetriculatorXMLDocument doc = x.getResult();
        this.injectProperties(doc);
        if (this.export_to_dir.isEmpty()) {
            this.export_to_dir = Path.fromOSString((String)System.getProperty("user.home")).append("metriculator-export");
        }
        this.export_to_dir = this.export_to_dir.append(this.report);
        IPath htmlFilename = this.export_to_dir.append("index").addFileExtension("html");
        IPath xmlFilename = this.export_to_dir.append("model").addFileExtension("xml");
        String xml = x.getFormattedXML();
        this.writeTo(xmlFilename, xml);
        StreamSource xmlStream = new StreamSource(new File(xmlFilename.toOSString()));
        StreamSource xslStream = new StreamSource(this.getProjectFile(RESOURCES_BASE_PATH + this.report + "/html.xslt"));
        this.copyResourcesTo(this.export_to_dir);
        this.transform(xmlStream, xslStream, new StreamResult(htmlFilename.toOSString()));
        this.open(this.export_to_dir);
    }

    private void injectProperties(MetriculatorXMLDocument xml) {
        Node propEl = xml.propertiesElement;
        Element themeEl = xml.doc.createElement("theme");
        themeEl.setAttribute("name", this.theme);
        propEl.appendChild(themeEl);
    }

    private void transform(StreamSource xmlStream, StreamSource xslStream, StreamResult result) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(xslStream);
            Transformer transformer = template.newTransformer();
            transformer.transform(xmlStream, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void copyResourcesTo(IPath export_location) {
        HTMLReportGenerator.copyFolder(RESOURCES_BASE_PATH + this.report, export_location);
    }
}

